/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Vector;
import ProGAL.math.Constants;

public class Line {
    protected Point p;
    protected Vector dir;

    public Line(Vector d) {
        this.p = new Point(0.0, 0.0, 0.0);
        this.dir = d.normalize();
    }

    public Line(Point p, Vector d) {
        this.p = p;
        this.dir = d.normalize();
    }

    public Line(LineSegment s) {
        this.p = s.getA().clone();
        this.dir = s.getAToB().normalize();
    }

    public Line(Point p1, Point p2) {
        this(p1, p1.vectorTo(p2));
    }

    public Line(Point a, Point b, Point c) {
        Circle circle = new Circle(a, b, c);
        this.p = circle.getCenter();
        this.dir = new Vector(a, b).cross(new Vector(a, c)).normalizeThis();
    }

    public Line clone() {
        return new Line(new Point(this.p), new Vector(this.dir));
    }

    public Point getP() {
        return this.p;
    }

    public Vector getDir() {
        return this.dir;
    }

    public Point getPoint(double t) {
        return new Point(this.p.x() + t * this.dir.x(), this.p.y() + t * this.dir.y(), this.p.z() + t * this.dir.z());
    }

    public Point orthogonalProjection(Point q) {
        return this.getPoint(this.orthogonalProjectionParameter(q));
    }

    public double orthogonalProjectionParameter(Point q) {
        Vector pq = this.p.vectorTo(q);
        return pq.dot(this.dir) / this.dir.getLengthSquared();
    }

    public LineSegment orthogonalProjection(PointList points) {
        double minT = Double.POSITIVE_INFINITY;
        double maxT = Double.NEGATIVE_INFINITY;
        for (Point q : points) {
            double t = this.orthogonalProjectionParameter(q);
            minT = Math.min(minT, t);
            maxT = Math.max(maxT, t);
        }
        return new LineSegment(this.getPoint(minT), this.getPoint(maxT));
    }

    public double[] orthogonalProjectionParameters(PointList points) {
        double minT = Double.POSITIVE_INFINITY;
        double maxT = Double.NEGATIVE_INFINITY;
        for (Point q : points) {
            double t = this.orthogonalProjectionParameter(q);
            minT = Math.min(minT, t);
            maxT = Math.max(maxT, t);
        }
        return new double[]{minT, maxT};
    }

    public double getDistanceSquared(Point q) {
        return this.dir.cross(q.vectorTo(this.p)).getLengthSquared() / this.dir.getLengthSquared();
    }

    public double getDistance(Point q) {
        return Math.sqrt(this.getDistanceSquared(q));
    }

    public double getSquaredDistance(Line l) {
        double a = this.dir.getLengthSquared();
        double b = this.dir.dot(l.dir);
        double e = l.dir.getLengthSquared();
        double d = a * e - b * b;
        if (Math.abs(d) < Constants.EPSILON) {
            return this.getDistanceSquared(l.p);
        }
        Vector r = l.p.vectorTo(this.p);
        double c = this.dir.dot(r);
        double f = l.dir.dot(r);
        double s = (b * f - c * e) / d;
        double t = (a * f - b * c) / d;
        double dx = this.p.x() + s * this.dir.x() - (l.p.x() + t * l.dir.x());
        double dy = this.p.y() + s * this.dir.y() - (l.p.y() + t * l.dir.y());
        double dz = this.p.z() + s * this.dir.z() - (l.p.z() + t * l.dir.z());
        return dx * dx + dy * dy + dz * dz;
    }

    public Point getIntersection(Line l) {
        double dz;
        double dy;
        double a = this.dir.getLengthSquared();
        double b = this.dir.dot(l.dir);
        double e = l.dir.getLengthSquared();
        double d = a * e - b * b;
        if (Math.abs(d) < Constants.EPSILON) {
            return null;
        }
        Vector r = l.p.vectorTo(this.p);
        double c = this.dir.dot(r);
        double f = l.dir.dot(r);
        double s = (b * f - c * e) / d;
        double t = (a * f - b * c) / d;
        double dx = this.p.x() + s * this.dir.x() - (l.p.x() + t * l.dir.x());
        if (dx * dx + (dy = this.p.y() + s * this.dir.y() - (l.p.y() + t * l.dir.y())) * dy + (dz = this.p.z() + s * this.dir.z() - (l.p.z() + t * l.dir.z())) * dz > Constants.EPSILON) {
            return null;
        }
        return new Point(this.p.x() + s * this.dir.x(), this.p.y() + s * this.dir.y(), this.p.z() + s * this.dir.z());
    }

    public double getMaxDistanceSquared(PointList points) {
        if (points.size() == 0) {
            throw new Error("No point");
        }
        double maxDist = Double.NEGATIVE_INFINITY;
        for (Point q : points) {
            double dist = this.getDistanceSquared(q);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        return maxDist;
    }

    public double getMaxDistance(PointList points) {
        return Math.sqrt(this.getMaxDistanceSquared(points));
    }

    public Point rotate(Point p, double angle) {
        Point ret = p.clone();
        return this.rotateIn(ret, angle);
    }

    public Point rotateIn(Point point, double angle) {
        Vector v = this.p.vectorTo(point);
        this.dir.rotateIn(v, angle);
        for (int i = 0; i < 3; ++i) {
            point.set(i, v.get(i) + this.p.get(i));
        }
        return point;
    }

    public double optimalRotation(Point[] moving, Point[] target) {
        Point[] f = target;
        Point[] m = moving;
        if (f.length != m.length) {
            throw new RuntimeException("Lengths must match");
        }
        double tanNum = 0.0;
        double tanDenom = 0.0;
        for (int i = 0; i < m.length; ++i) {
            Point O_i = this.orthogonalProjection(m[i]);
            Vector fVec = O_i.vectorTo(f[i]);
            Vector rVec = O_i.vectorTo(m[i]);
            Vector sVec = this.dir.cross(rVec).normalizeThis();
            double rLen = rVec.length();
            rVec.multiplyThis(1.0 / rLen);
            tanNum += fVec.dot(sVec) * rLen;
            tanDenom += fVec.dot(rVec) * rLen;
        }
        double alpha = Math.atan(tanNum / tanDenom);
        double secDeriv = Math.cos(alpha) * tanDenom + Math.sin(alpha) * tanNum;
        if (secDeriv < 0.0) {
            alpha -= Math.signum(alpha) * Math.PI;
        }
        return alpha;
    }

    public String toString() {
        return String.format("Line3d[p:%s,dir:%s]", this.p, this.dir);
    }

    public String toString(int dec) {
        return String.format("Line3d[p:%s,dir:%s]", this.p.toString(dec), this.dir.toString(dec));
    }
}

