/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.viewer;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Vector;

public class TextShape
implements Shape {
    private String text;
    private double height;
    private Point pos;
    private double angle;

    public TextShape(String text, Point pos, double height) {
        this(text, pos, height, 0.0);
    }

    public TextShape(String text, Point pos, double height, double angle) {
        this.text = text;
        this.height = height;
        this.pos = pos;
        this.angle = angle;
    }

    public double getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public Point getPos() {
        return this.pos;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public Point getCenter() {
        return this.pos.clone();
    }

    @Override
    public boolean contains(Point p) {
        Vector v = this.pos.vectorTo(p);
        double dX = v.get(0);
        double dY = v.get(1);
        return dX > 0.0 && dX < this.height * (double)this.text.length() / 2.0 && dY > 0.0 && dY < this.height;
    }
}

