/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.viewer;

import ProGAL.geom2d.Circle;
import ProGAL.geom2d.viewer.J2DScene;
import ProGAL.geom2d.viewer.ShapePainter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

class CirclePainter
implements ShapePainter {
    CirclePainter() {
    }

    @Override
    public void paintShape(J2DScene.ShapeOptions shape, Graphics2D g2d) {
        Circle circle = (Circle)shape.shape;
        Point gPoint = shape.transformPoint(circle.center());
        int diam = (int)(circle.getRadius() * 2.0 * shape.getScale());
        g2d.setColor(shape.color);
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke((float)(shape.getScale() * shape.borderWidth)));
        if (shape.fill) {
            g2d.fillArc(gPoint.x - diam / 2, gPoint.y - diam / 2, diam, diam, 0, 360);
        } else {
            g2d.drawArc(gPoint.x - diam / 2, gPoint.y - diam / 2, diam, diam, 0, 360);
        }
        g2d.setStroke(oldStroke);
    }
}

