/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Point;

public class Vector
extends ProGAL.geomNd.Vector {
    public Vector(double x, double y) {
        super(new double[]{x, y});
    }

    public Vector(double[] coords) {
        super(coords);
    }

    public Vector(Point p, Point q) {
        this(q.x() - p.x(), q.y() - p.y());
    }

    public Vector(Point p) {
        this(p.x(), p.y());
    }

    public double x() {
        return this.coords[0];
    }

    public double y() {
        return this.coords[1];
    }

    public double[] getCoords() {
        return this.coords;
    }

    public double getSquaredLength() {
        return this.coords[0] * this.coords[0] + this.coords[1] * this.coords[1];
    }

    @Override
    public double length() {
        return Math.sqrt(this.getSquaredLength());
    }

    public double getSlope() {
        if (this.coords[0] == 0.0) {
            return 9999.0;
        }
        return this.coords[1] / this.coords[0];
    }

    public void negative() {
        this.scale(-1.0);
    }

    public Vector scale(double a) {
        this.coords[0] = this.coords[0] * a;
        this.coords[1] = this.coords[1] * a;
        return this;
    }

    public Vector rotateThis(double a) {
        double cosA = Math.cos(a);
        double sinA = Math.sin(a);
        double xOld = this.get(0);
        this.coords[0] = cosA * this.coords[0] - sinA * this.coords[1];
        this.coords[1] = sinA * xOld + cosA * this.coords[1];
        return this;
    }

    public Vector add(Vector v) {
        return new Vector(this.coords[0] + v.coords[0], this.coords[1] + v.coords[1]);
    }

    public Vector addThis(Vector v) {
        this.coords[0] = this.coords[0] + v.coords[0];
        this.coords[1] = this.coords[1] + v.coords[1];
        return this;
    }

    public Vector addThis(Point p) {
        this.coords[0] = this.coords[0] + p.x();
        this.coords[1] = this.coords[1] + p.y();
        return this;
    }

    @Override
    public Vector multiply(double a) {
        return new Vector(a * this.coords[0], a * this.coords[1]);
    }

    @Override
    public Vector multiplyThis(double a) {
        this.coords[0] = this.coords[0] * a;
        this.coords[1] = this.coords[1] * a;
        return this;
    }

    @Override
    public Vector normalize() {
        return this.multiply(1.0 / this.length());
    }

    @Override
    public Vector normalizeThis() {
        return this.multiply(1.0 / this.length());
    }

    public Vector createRotatedVector(double a) {
        return new Vector(Math.cos(a) * this.coords[0] - Math.sin(a) * this.coords[1], Math.sin(a) * this.coords[0] + Math.cos(a) * this.coords[1]);
    }

    public Vector rotate90() {
        return new Vector(-this.coords[1], this.coords[0]);
    }

    public Vector rotate90This() {
        double tmp = this.coords[0];
        this.coords[0] = -this.coords[1];
        this.coords[1] = tmp;
        return this;
    }

    @Override
    public Point toPoint() {
        return new Point(this.coords[0], this.coords[1]);
    }

    public static Vector createSum(Vector u, Vector v) {
        return new Vector(u.coords[0] + v.coords[0], u.coords[1] + v.coords[1]);
    }

    public static Vector createDiff(Vector u, Vector v) {
        return new Vector(u.coords[0] - v.coords[0], u.coords[1] - v.coords[1]);
    }

    public static double crossProduct(Vector u, Vector v) {
        return u.coords[0] * v.coords[1] - u.coords[1] * v.coords[1];
    }

    public static double dotProduct(Vector u, Vector v) {
        return u.coords[0] * v.coords[0] + u.coords[1] * v.coords[1];
    }

    public static boolean leftTurn(Vector u, Vector v) {
        return Vector.crossProduct(u, v) > 0.0;
    }

    public static boolean rightTurn(Vector u, Vector v) {
        return Vector.crossProduct(u, v) <= 0.0;
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    @Override
    public String toString(int dec) {
        return String.format("Vector[%" + dec + "f,%f" + dec + "]", this.coords[0], this.coords[1]);
    }

    @Override
    public void toConsole() {
        this.toConsole(2);
    }

    @Override
    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    @Override
    public Vector scaleToLength(double l) {
        double l2 = this.length();
        return new Vector(l * this.coords[0] / l2, l * this.coords[1] / l2);
    }

    public double dot(Vector v) {
        return this.coords[0] * v.coords[0] + this.coords[1] * v.coords[1];
    }

    @Override
    public Vector clone() {
        return new Vector(this.coords[0], this.coords[1]);
    }
}

