/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Vector;
import ProGAL.geom2d.viewer.J2DScene;
import java.awt.Color;

public class LineSegment
implements Shape {
    protected Point a;
    protected Point b;

    public LineSegment(Point a, Point b) {
        this.a = a;
        this.b = b;
    }

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public void setA(Point p) {
        this.a = p;
    }

    public void setB(Point p) {
        this.b = p;
    }

    public double getLength() {
        return this.a.distance(this.b);
    }

    public double getSquaredLength() {
        double bax = this.b.x() - this.a.x();
        double bay = this.b.y() - this.a.y();
        return bax * bax + bay * bay;
    }

    public LineSegment clone() {
        return new LineSegment(this.a.clone(), this.b.clone());
    }

    @Override
    public Point getCenter() {
        return Point.midPoint(this.a, this.b);
    }

    public LineSegment reverse() {
        Point c = this.a;
        this.a = this.b;
        this.b = c;
        return this;
    }

    public boolean intersects(LineSegment s) {
        return (Point.leftTurn(this.a, this.b, s.a) && Point.leftTurn(this.b, this.a, s.b) || Point.leftTurn(this.a, this.b, s.b) && Point.leftTurn(this.b, this.a, s.a)) && (Point.leftTurn(s.a, s.b, this.a) && Point.leftTurn(s.b, s.a, this.b) || Point.leftTurn(s.a, s.b, this.b) && Point.leftTurn(s.b, s.a, this.a));
    }

    public String toString() {
        return "[" + this.a.toString() + this.b.toString() + "]";
    }

    public void toConsole() {
        System.out.println("[" + this.a.toString() + this.b.toString() + "]");
    }

    public void toScene(J2DScene scene) {
        scene.addShape(this, Color.black);
    }

    public void toScene(J2DScene scene, Color clr) {
        scene.addShape(this, clr);
    }

    public void toScene(J2DScene scene, Color clr, double width) {
        scene.addShape(this, clr, width);
    }

    public double distance(Point p) {
        Vector v = this.a.vectorTo(this.b);
        Vector vP = this.a.vectorTo(p);
        double t = v.dot(vP) / v.getSquaredLength();
        return this.a.add(v.multiplyThis(Math.min(Math.max(0.0, t), 1.0))).distance(p);
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }
}

