/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Vector;
import ProGAL.math.Constants;

public class Line
implements Shape {
    protected Point p;
    protected Vector n;

    public Line(Point p, Vector n) {
        this.p = p;
        this.n = n.normalize();
    }

    public Line(Point p, Point q) {
        this.p = p;
        this.n = new Vector(p.y() - q.y(), q.x() - p.x());
        this.n.normalizeThis();
    }

    public Line(LineSegment seg) {
        this.p = seg.a;
        this.n = new Vector(seg.a.y() - seg.b.y(), seg.b.x() - seg.a.x());
        this.n = this.n.normalize();
    }

    public Line(double a, double b, double c) {
        this.n = new Vector(a, b);
        this.n.normalizeThis();
        this.p = b != 0.0 ? new Point(0.0, -c / b) : new Point(-c / a, 0.0);
    }

    public Line(double a, double c) {
        this.n = new Vector(-a, 1.0);
        this.n.normalizeThis();
        this.p = new Point(0.0, c);
    }

    public static Line getBisectorLine(Point p, Point q) {
        if (!p.equals(q)) {
            return new Line(Point.midPoint(p, q), p.vectorTo(q));
        }
        return null;
    }

    public Point getPoint() {
        return this.p;
    }

    public Vector getDirection() {
        return new Vector(this.n.y(), -this.n.x());
    }

    public double getSlope() {
        if (!this.isVertical()) {
            return this.n.x() / this.n.y();
        }
        return Double.MAX_VALUE;
    }

    public boolean isVertical() {
        return this.n.y() == 0.0;
    }

    public boolean isParallelWith(Line l) {
        return Math.abs(Vector.crossProduct(this.n, l.n)) < Constants.EPSILON;
    }

    public boolean isAbove(Point q) {
        return Point.leftTurn(this.p, this.p.add(this.getDirection()), q);
    }

    public boolean isBelow(Point q) {
        return Point.leftTurn(this.p, this.p.subtract(this.getDirection()), q);
    }

    public static boolean areParallel(Line l1, Line l2) {
        return Vector.crossProduct(l1.n, l2.n) == 0.0;
    }

    public void translateTo(Point p) {
        this.p = p;
    }

    public Point projectPoint(Point q) {
        double t = this.n.y() * (q.x() - this.p.x()) - this.n.x() * (q.y() - this.p.y());
        return new Point(this.n.y() * t + this.p.x(), this.p.y() - this.n.x() * t);
    }

    public double projectionParameter(Point q) {
        return this.n.y() * (q.x() - this.p.x()) - this.n.x() * (q.y() - this.p.y());
    }

    public static Point getIntersection(Line l1, Line l2) {
        double denom = l1.n.x() * l2.n.y() - l1.n.y() * l2.n.x();
        if (Math.abs(denom) < Constants.EPSILON) {
            throw new RuntimeException("Lines are parallel");
        }
        double e = l1.n.x() * l1.p.x() + l1.n.y() * l1.p.y();
        double f = l2.n.x() * l2.p.x() + l2.n.y() * l2.p.y();
        return new Point((e * l2.n.y() - f * l1.n.y()) / denom, (f * l1.n.x() - e * l2.n.x()) / denom);
    }

    public String toString(String name) {
        return "Line[" + name + ",point:" + this.p.toString() + ",normal:" + this.n.toString() + "]";
    }

    public String toString() {
        return this.toString("");
    }

    public void toConsole(String name) {
        System.out.println(this.toString(name));
    }

    public void toConsole() {
        System.out.println(this.toString(""));
    }

    public Point getPoint(double d) {
        Vector dir = this.getDirection();
        return new Point(this.p.x() + d * dir.x(), this.p.y() + d * dir.y());
    }

    public double getDistance(Point q) {
        return Math.abs(this.n.x() * q.x() + this.n.y() * q.y() - this.n.x() * this.p.x() - this.n.y() * this.p.y()) / Math.sqrt(this.n.x() * this.n.x() + this.n.y() * this.n.y());
    }

    public double intersectionParameter(Line l) {
        Vector dir = this.getDirection();
        Vector lDir = l.getDirection();
        double denom = lDir.y() * dir.x() - lDir.x() * dir.y();
        Vector c = l.p.vectorTo(this.p);
        double s = (lDir.x() * c.y() - lDir.y() * c.x()) / denom;
        return s;
    }

    @Override
    public Point getCenter() {
        return this.getPoint(0.0);
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }
}

