/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.ApolloniusSolver;
import ProGAL.geom2d.Line;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Triangle;
import ProGAL.geom2d.Vector;
import ProGAL.geom2d.viewer.J2DScene;
import ProGAL.math.Constants;
import ProGAL.math.Functions;
import java.awt.Color;
import java.util.List;

public class Circle
implements Shape {
    protected Point center;
    protected double radius;

    public Circle(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Circle(Circle c) {
        this.center = new Point(c.center.x(), c.center.y());
        this.radius = c.radius;
    }

    public Circle(Point p1, Point p2) {
        this(Point.midPoint(p1, p2), p1.distance(p2) / 2.0);
    }

    public Circle(Point a, Point b, Point c) {
        if (a.equals(b) || b.equals(c)) {
            this.center = Point.midPoint(a, c);
            this.radius = this.center.distance(a);
        } else if (a.equals(c)) {
            this.center = Point.midPoint(a, b);
            this.radius = this.center.distance(a);
        } else {
            Line bc;
            Line ab = Point.getBisector(a, b);
            if (ab.isParallelWith(bc = Point.getBisector(b, c))) {
                Point p1 = a;
                Point p2 = b;
                if (a.distance(b) < a.distance(c)) {
                    p2 = c;
                }
                if (b.distance(c) > p1.distance(p2)) {
                    p1 = b;
                }
                this.center = Point.midPoint(p1, p2);
                this.radius = p1.distance(p2);
            } else {
                this.center = Line.getIntersection(ab, bc);
                if (this.center == null) {
                    throw new Error(a + " " + b + " " + c);
                }
                this.radius = this.center.distance(b);
            }
        }
    }

    public Circle(Circle c1, Circle c2) {
        if (c1.contains(c2)) {
            this.center = c1.center.clone();
            this.radius = c1.radius;
        } else if (c2.contains(c1)) {
            this.center = c2.center.clone();
            this.radius = c2.radius;
        } else if (c1.center.equals(c2.center)) {
            this.center = c1.center.clone();
            this.radius = Math.max(c1.radius, c2.radius);
        } else {
            Line l = new Line(c1.center, c2.center);
            this.center = l.getPoint(0.5 * c1.center.distance(c2.center) - c1.radius / 2.0 + c2.radius / 2.0);
            this.radius = this.center.distance(c1.center) + c1.radius;
        }
    }

    public Circle(Circle circle1, Circle circle2, Circle circle3) {
        Circle c1 = circle1;
        Circle c2 = circle2;
        Circle c3 = circle3;
        Circle tmp = new Circle(c1, c2);
        if (tmp.contains(c3)) {
            this.center = tmp.center;
            this.radius = tmp.radius;
            return;
        }
        tmp = new Circle(c1, c3);
        if (tmp.contains(c2)) {
            this.center = tmp.center;
            this.radius = tmp.radius;
            return;
        }
        tmp = new Circle(c2, c3);
        if (tmp.contains(c1)) {
            this.center = tmp.center;
            this.radius = tmp.radius;
            return;
        }
        Circle mec = ApolloniusSolver.solveApollonius(c1, c2, c3, 1, 1, 1);
        this.center = mec.center;
        this.radius = mec.radius;
    }

    public Circle(Triangle tri) {
        this(tri.getCorner(0), tri.getCorner(1), tri.getCorner(2));
    }

    public Point center() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setCenter(Point p) {
        this.center = p;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public void translate(Vector v) {
        this.center.addThis(v);
    }

    public Double enteringAngle(Point p, Circle C, boolean ccw) {
        double centerDist = this.center.distance(C.center);
        if (centerDist < C.radius + this.radius) {
            double alpha = Math.acos(((p.x() - this.center.x()) * (C.center.x() - this.center.x()) + (p.y() - this.center.y()) * (C.center.y() - this.center.y())) / (this.radius * centerDist));
            double beta = Math.acos((centerDist * centerDist + this.radius * this.radius - C.radius * C.radius) / (2.0 * centerDist * this.radius));
            alpha = ccw ? (Point.rightTurn(C.center, this.center, p) ? alpha + Math.PI - beta : (alpha -= beta)) : (Point.leftTurn(C.center, this.center, p) ? alpha + beta - Math.PI * 2 : beta - alpha);
            System.out.println("alpha = " + Functions.toDeg(alpha));
            return alpha;
        }
        return null;
    }

    public Double exitingAngle(Point p, Circle C, boolean ccw) {
        double centerDist = this.center.distance(C.center);
        Double alpha = Math.acos(((p.x() - this.center.x()) * (C.center.x() - this.center.x()) + (p.y() - this.center.y()) * (C.center.y() - this.center.y())) / (this.radius * centerDist));
        Double beta = Math.acos((centerDist * centerDist + this.radius * this.radius - C.radius * C.radius) / (2.0 * centerDist * this.radius));
        alpha = ccw ? (Point.rightTurn(C.center, this.center, p) ? Double.valueOf(alpha - beta) : Double.valueOf(alpha + beta)) : (Point.leftTurn(C.center, this.center, p) ? Double.valueOf(beta - alpha) : Double.valueOf(-alpha.doubleValue() - beta));
        System.out.println("alpha = " + Functions.toDeg(alpha));
        return alpha;
    }

    public Double enteringAngle(Point p, Line L, boolean ccw) {
        double dist = L.getDistance(p);
        if (dist < this.radius) {
            Point q = L.projectPoint(this.center);
            double alpha = Math.acos(((p.x() - this.center.x()) * (q.x() - this.center.x()) + (p.y() - this.center.y()) * (q.y() - this.center.y())) / (this.radius * dist));
            double beta = Math.acos(dist / this.radius);
            if (ccw) {
                if (Point.rightTurn(q, this.center, p)) {
                    alpha = Math.PI * 2 - alpha;
                }
            } else {
                alpha = -alpha;
                beta = -beta;
                if (Point.leftTurn(q, this.center, p)) {
                    alpha = Math.PI * -2 - alpha;
                }
            }
            System.out.println("alpha = " + Functions.toDeg(alpha));
            System.out.println("beta  = " + Functions.toDeg(beta));
            return alpha - beta;
        }
        return null;
    }

    public Point[] intersections(Circle c) {
        Point[] ret = new Point[2];
        double centerDist = this.center.distance(c.center);
        if (centerDist < c.radius + this.radius) {
            if (centerDist + this.radius < c.radius || centerDist + c.radius < this.radius) {
                return null;
            }
            if (centerDist + this.radius == c.radius) {
                ret[0] = c.center.add(c.center.vectorTo(this.center).scaleToLength(c.radius));
                ret[1] = null;
                return ret;
            }
            if (centerDist + c.radius == this.radius) {
                ret[0] = this.center.add(this.center.vectorTo(c.center).scaleToLength(this.radius));
                ret[1] = null;
                return ret;
            }
            double dSq = c.center.distanceSquared(this.center);
            double d = Math.sqrt(dSq);
            double RSq = this.radius * this.radius;
            double rSq = c.radius * c.radius;
            double tmp = dSq - rSq + RSq;
            double d1 = tmp / (2.0 * d);
            double a = Math.sqrt(4.0 * dSq * RSq - tmp * tmp) / d;
            Vector x = this.center.vectorTo(c.center).normalizeThis();
            Vector y = x.rotate90();
            x.multiplyThis(d1);
            y.multiplyThis(a / 2.0);
            ret[0] = this.center.add(x).addThis(y);
            ret[1] = this.center.add(x).subtractThis(y);
            return ret;
        }
        if (centerDist == c.radius + this.radius) {
            ret[0] = this.center.add(this.center.vectorTo(c.center).scaleToLength(this.radius));
            ret[1] = null;
            return ret;
        }
        return null;
    }

    public Point[] intersections(Line l) {
        double x2;
        double y1;
        double y2;
        double x1;
        double D;
        double dy;
        double dx = l.n.y();
        double dr2 = dx * dx + (dy = -l.n.x()) * dy;
        double delta = this.radius * this.radius * dr2 - (D = (x1 = l.p.x() - this.center.x()) * (y2 = (y1 = l.p.y() - this.center.y()) - dy) - (x2 = x1 - dx) * y1) * D;
        if (delta < -Constants.EPSILON) {
            return null;
        }
        if (delta < Constants.EPSILON) {
            Point[] ret = new Point[]{new Point(this.center.x() + D * dy / dr2, this.center.y() - D * dx / dr2)};
            return ret;
        }
        Point[] ret = new Point[2];
        double deltaRoot = Math.sqrt(delta);
        if (dy < 0.0) {
            ret[0] = new Point(this.center.x() + (D * dy - dx * deltaRoot) / dr2, this.center.y() - (D * dx + dy * deltaRoot) / dr2);
            ret[1] = new Point(this.center.x() + (D * dy + dx * deltaRoot) / dr2, this.center.y() - (D * dx - dy * deltaRoot) / dr2);
        } else {
            ret[0] = new Point(this.center.x() + (D * dy + dx * deltaRoot) / dr2, this.center.y() - (D * dx - dy * deltaRoot) / dr2);
            ret[1] = new Point(this.center.x() + (D * dy - dx * deltaRoot) / dr2, this.center.y() - (D * dx + dy * deltaRoot) / dr2);
        }
        return ret;
    }

    public static Circle minimumEnclosingCircle_Welzl(List<Point> points) {
        Point[] b = new Point[3];
        return Circle.findMEC(points.size(), points, 0, b);
    }

    private static Circle findMEC(int n, List<Point> points, int m, Point[] b) {
        Circle mec = new Circle(new Point(0.0, 0.0), 0.0);
        if (m == 1) {
            mec = new Circle(b[0], 0.0);
        } else if (m == 2) {
            mec = new Circle(b[0], b[1]);
        } else if (m == 3) {
            return new Circle(b[0], b[1], b[2]);
        }
        for (int i = 0; i < n; ++i) {
            if (mec.contains(points.get(i))) continue;
            b[m] = points.get(i);
            mec = Circle.findMEC(i, points, m + 1, b);
        }
        return mec;
    }

    double getPowerDistance(Point p) {
        return this.center.distanceSquared(p) - this.radius * this.radius;
    }

    double getPowerDistance(Circle c) {
        return this.getPowerDistance(c.center) - c.radius * c.radius;
    }

    public boolean isEmpty(List<Point> points, double eps) {
        for (Point p : points) {
            if (!this.contains(p, eps)) continue;
            return false;
        }
        return true;
    }

    boolean isOrthogonal(Circle c) {
        return this.getPowerDistance(c) == 0.0;
    }

    @Deprecated
    public static Circle minimumEnclosingCircle_bruteforce(List<Point> points) {
        int j;
        int i;
        System.err.println("Warning: Please only use Circle.minimumEnclosingCircle_bruteforce for testing purposes!!");
        double minRad = Double.POSITIVE_INFINITY;
        Circle minCircle = null;
        for (i = 0; i < points.size(); ++i) {
            for (j = i; j < points.size(); ++j) {
                if (i == j) continue;
                Circle tmp = new Circle(points.get(i), points.get(j));
                boolean containsAll = true;
                for (Point p : points) {
                    if (tmp.contains(p)) continue;
                    containsAll = false;
                    break;
                }
                if (!containsAll || !(tmp.radius < minRad)) continue;
                minRad = tmp.radius;
                minCircle = tmp;
            }
        }
        for (i = 0; i < points.size(); ++i) {
            for (j = i; j < points.size(); ++j) {
                for (int k = j; k < points.size(); ++k) {
                    if (i == j || i == k || j == k) continue;
                    Circle tmp = new Circle(points.get(i), points.get(j), points.get(k));
                    boolean containsAll = true;
                    for (Point p : points) {
                        if (tmp.contains(p)) continue;
                        containsAll = false;
                        break;
                    }
                    if (!containsAll || !(tmp.radius < minRad)) continue;
                    minRad = tmp.radius;
                    minCircle = tmp;
                }
            }
        }
        if (minCircle == null) {
            throw new Error("minCircle not set .. " + points.size());
        }
        return minCircle;
    }

    @Override
    public boolean contains(Point p) {
        return this.center.distanceSquared(p) < this.radius * this.radius;
    }

    public boolean contains(Point p, double eps) {
        return this.center.distanceSquared(p) < this.radius * this.radius - eps;
    }

    public boolean contains(Circle c) {
        return this.radius >= this.center.distance(c.center) + c.radius - 1.0E-6;
    }

    public boolean onCircle(Point p) {
        return Math.abs(this.center.distanceSquared(p) - this.radius * this.radius) < Constants.EPSILON;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Circle[%s,%" + dec + "f]", this.center, this.radius);
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    public void toScene(J2DScene scene) {
        scene.addShape(this, Color.black);
    }

    public void toScene(J2DScene scene, Color clr) {
        scene.addShape(this, clr);
    }

    @Override
    public Point getCenter() {
        return this.center;
    }
}

