/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.dataStructures;

import ProGAL.dataStructures.SortTool;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;

public class SortToolPoint2dAroundPoint
implements SortTool {
    Point p;
    double x;
    double y;

    public SortToolPoint2dAroundPoint(Point p) {
        this.p = p;
        this.x = p.x();
        this.y = p.y();
    }

    @Override
    public int compare(Object p1, Object p2) {
        double x1 = ((Point)p1).x() - this.x;
        double x2 = ((Point)p2).x() - this.x;
        double y1 = ((Point)p1).y() - this.y;
        double y2 = ((Point)p2).y() - this.y;
        if (p1 instanceof LineSegment && p2 instanceof LineSegment) {
            if (y1 > this.y) {
                if (y2 < this.y) {
                    return -1;
                }
                if (y2 > this.y) {
                    if (Point.leftTurn(this.p, (Point)p1, (Point)p2)) {
                        return -1;
                    }
                    if (Point.collinear(this.p, (Point)p1, (Point)p2) && (x1 - this.x) * (x1 - this.x) + (y1 - this.y) * (y1 - this.y) < (x2 - this.x) * (x2 - this.x) + (y2 - this.y) * (y2 - this.y)) {
                        return -1;
                    }
                    return 1;
                }
                if (x2 >= this.x) {
                    return 1;
                }
                return -1;
            }
            if (y1 < this.y) {
                if (y2 >= this.y) {
                    return 1;
                }
                if (Point.leftTurn(this.p, (Point)p1, (Point)p2)) {
                    return -1;
                }
                if (Point.collinear(this.p, (Point)p1, (Point)p2) && (x1 - this.x) * (x1 - this.x) + (y1 - this.y) * (y1 - this.y) < (x2 - this.x) * (x2 - this.x) + (y2 - this.y) * (y2 - this.y)) {
                    return -1;
                }
                return 1;
            }
            if (x1 >= this.x) {
                if (y2 == this.y && (x1 < x2 || x2 < this.x)) {
                    return -1;
                }
                return 1;
            }
            if (y2 > this.y) {
                return 1;
            }
            if (y2 < this.y) {
                return -1;
            }
            if (x2 > x1) {
                return 1;
            }
            return -1;
        }
        throw SortTool.err1;
    }
}

