/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.dataStructures;

import ProGAL.dataStructures.SortTool;
import ProGAL.dataStructures.SortToolDouble;
import ProGAL.dataStructures.SortToolInteger;
import ProGAL.dataStructures.SortToolPoint2dDistance;
import ProGAL.dataStructures.SortToolString;
import ProGAL.dataStructures.SorterQuick;
import ProGAL.geom2d.Point;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class Set<T>
implements Iterable<T> {
    protected Object[] elements;
    protected int n;

    public Set() {
        this(0);
    }

    public Set(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elements = new Object[capacity];
        this.n = 0;
    }

    public Set(Object element) {
        this.n = 1;
        this.elements = new Object[this.n];
        this.elements[0] = element;
    }

    public Set(Object[] elements) {
        this.n = elements.length;
        this.elements = new Object[this.n];
        System.arraycopy(elements, 0, this.elements, 0, this.n);
    }

    public Set(Set<T> set) {
        this.n = set.getSize();
        this.elements = new Object[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.elements[i] = set.get(i);
        }
    }

    public void clear() {
        for (int i = 0; i < this.n; ++i) {
            this.elements[i] = null;
        }
        this.n = 0;
    }

    public boolean isEmpty() {
        return this.n == 0;
    }

    public T get(int i) {
        if (i < 0 || i >= this.n) {
            throw new IllegalArgumentException("index out of range");
        }
        return (T)this.elements[i];
    }

    public T getFirst() {
        if (this.n == 0) {
            throw new IllegalArgumentException("the set is empty");
        }
        return (T)this.elements[0];
    }

    public T getLast() {
        if (this.n == 0) {
            throw new IllegalArgumentException("the set is empty");
        }
        return (T)this.elements[this.n - 1];
    }

    public void set(int i, Object element) {
        this.elements[i] = element;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public int getSize() {
        return this.n;
    }

    public void randomPermutation() {
        Random random = new Random();
        for (int i = 0; i < this.n; ++i) {
            int j = random.nextInt(this.n - i);
            this.swap(i, i + j);
        }
    }

    public int findIndex(Object object) {
        for (int k = 0; k < this.n; ++k) {
            if (this.elements[k] != object) continue;
            return k;
        }
        return -1;
    }

    public boolean contains(Object object) {
        return this.findIndex(object) != -1;
    }

    public boolean isMember(Object object) {
        return this.findIndex(object) != -1;
    }

    public void insert(T object) {
        if (this.n >= this.elements.length) {
            int newCapacity = 3 * this.elements.length / 2 + 1;
            Object[] newElements = new Object[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            this.elements = newElements;
        }
        this.elements[this.n++] = object;
    }

    public void append(Set<T> setToAppend) {
        int size = setToAppend.getSize();
        for (int i = 0; i < size; ++i) {
            this.insert(setToAppend.get(i));
        }
    }

    public void append(T[] array) {
        for (T t : array) {
            this.insert(t);
        }
    }

    public void reverse() {
        Object[] tempElements = new Object[this.n];
        System.arraycopy(this.elements, 0, tempElements, 0, this.n);
        for (int i = 0; i < this.n; ++i) {
            this.elements[i] = tempElements[this.n - i - 1];
        }
    }

    public void delete(Object object) {
        this.deleteIndex(this.findIndex(object));
    }

    public Object deleteIndex(int k) {
        if (k < 0 || k >= this.n) {
            throw new IllegalArgumentException("object not in the set");
        }
        Object object = this.elements[k];
        this.elements[k] = this.elements[this.n - 1];
        this.elements[--this.n] = null;
        if (this.n <= this.elements.length / 4) {
            int newCapacity = this.elements.length / 2 + 1;
            Object[] newElements = new Object[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.n);
            this.elements = newElements;
        }
        return object;
    }

    public Object deleteFirst() {
        return this.deleteIndex(0);
    }

    public Object deleteLast() {
        return this.deleteIndex(this.n - 1);
    }

    public void swap(int i, int j) {
        if (i < 0 || i >= this.n || j < 0 || j >= this.n) {
            throw new IllegalArgumentException("object not in the set");
        }
        Object temp = this.elements[i];
        this.elements[i] = this.elements[j];
        this.elements[j] = temp;
    }

    public void shift(int i) {
        int j;
        Object[] elementsCopy = new Object[i];
        System.arraycopy(this.elements, 0, elementsCopy, 0, i);
        for (j = i; j < this.n; ++j) {
            this.elements[j - i] = this.elements[j];
        }
        for (j = 0; j < i; ++j) {
            this.elements[this.getSize() - i + j] = elementsCopy[j];
        }
    }

    public boolean isEqual(Set<T> set2) {
        for (int i = 0; i < this.n; ++i) {
            if (set2.contains(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object binarySearch(SortTool tool, Object object) {
        return this.binarySearch(tool, object, 0, this.getSize() - 1);
    }

    private Object binarySearch(SortTool tool, Object object, int left, int right) {
        if (right == left) {
            return null;
        }
        int mid = left + (right - left) / 2;
        if (tool.compare(object, this.get(mid)) < 0) {
            return this.binarySearch(tool, object, left, mid - 1);
        }
        if (tool.compare(object, this.get(mid)) > 0) {
            return this.binarySearch(tool, object, mid + 1, right);
        }
        return this.get(mid);
    }

    public int partition(SortTool tool, int left, int right) {
        int i = left;
        T pivot = this.get(right);
        for (int k = left; k < right; ++k) {
            if (tool.compare(this.get(k), pivot) >= 0) continue;
            this.swap(i++, k);
        }
        this.swap(i, right);
        return i;
    }

    public void sort() {
        if (!this.isEmpty()) {
            SorterQuick sorter = new SorterQuick();
            T obj = this.get(0);
            if (obj instanceof Integer) {
                sorter.Sort(this, new SortToolInteger());
            } else if (obj instanceof Double) {
                sorter.Sort(this, new SortToolDouble());
            } else if (obj instanceof String) {
                sorter.Sort(this, new SortToolString());
            } else if (obj instanceof Point) {
                sorter.Sort(this, new SortToolPoint2dDistance());
            }
        }
    }

    public static void main(String[] args) {
        int i;
        Set<Integer> s = new Set<Integer>(100);
        Random randGen = new Random();
        for (i = 0; i < 100; ++i) {
            s.insert(new Integer(randGen.nextInt(1000)));
        }
        for (i = 0; i < 100; ++i) {
            System.out.print(s.get(i) + " ");
        }
        System.out.println();
        s.sort();
        for (i = 0; i < 100; ++i) {
            System.out.print(s.get(i) + " ");
        }
        System.out.println();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int cur = 0;

            @Override
            public boolean hasNext() {
                return this.cur < Set.this.getSize();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return Set.this.elements[this.cur++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

