/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.dataStructures;

import ProGAL.dataStructures.Set;
import ProGAL.dataStructures.SortTool;

public class Heap {
    protected Object[] nodes;
    protected int count = 0;
    protected SortTool tool;

    public Heap(int capacity, SortTool tool) throws IllegalArgumentException {
        if (capacity < 0) {
            capacity = 0;
        }
        this.nodes = new Object[capacity];
        this.tool = tool;
    }

    public Heap(int capacity) {
        this(capacity, null);
    }

    public Heap(Set<Object> set, SortTool tool) {
        this.count = set.getSize();
        this.nodes = new Object[this.count];
        this.tool = tool;
        System.arraycopy(set.getElements(), 0, this.nodes, 0, this.count);
        for (int i = this.parent(this.count - 1); i >= 0; --i) {
            this.siftDown(i);
        }
    }

    protected final int parent(int k) {
        return (k - 1) / 2;
    }

    protected final int left(int k) {
        return 2 * k + 1;
    }

    protected final int right(int k) {
        return 2 * (k + 1);
    }

    public Object[] getObjects() {
        return this.nodes;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int getSize() {
        return this.count;
    }

    public Object getItem(int i) {
        return this.nodes[i];
    }

    public void setItem(int i, Object x) {
        this.nodes[i] = x;
    }

    public void siftUp(int k) {
        int q = k;
        while (q > 0 && this.tool.compare(this.nodes[q], this.nodes[this.parent(q)]) < 0) {
            int p = this.parent(q);
            Object temp = this.nodes[q];
            this.nodes[q] = this.nodes[p];
            this.nodes[p] = temp;
            q = p;
        }
    }

    public void siftDown(int k) {
        int r;
        int min;
        int q = k;
        int l = this.left(q);
        while (l < this.count && this.tool.compare(this.nodes[min = (r = this.right(q)) == this.count || this.tool.compare(this.nodes[l], this.nodes[r]) < 0 ? l : r], this.nodes[q]) < 0) {
            Object temp = this.nodes[q];
            this.nodes[q] = this.nodes[min];
            this.nodes[min] = temp;
            q = min;
            l = this.left(q);
        }
    }

    public synchronized void insert(Object x) {
        if (this.count >= this.nodes.length) {
            int newcap = 3 * this.nodes.length / 2 + 1;
            Object[] newnodes = new Object[newcap];
            System.arraycopy(this.nodes, 0, newnodes, 0, this.nodes.length);
            this.nodes = newnodes;
        }
        this.nodes[this.count++] = x;
        this.siftUp(this.count - 1);
    }

    public synchronized Object extract() {
        if (this.count < 1) {
            return null;
        }
        Object x = this.nodes[0];
        --this.count;
        this.nodes[0] = this.nodes[this.count];
        this.nodes[this.count] = null;
        this.siftDown(0);
        return x;
    }

    public synchronized Object peek() {
        if (this.count > 0) {
            return this.nodes[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.nodes[i] = null;
        }
        this.count = 0;
    }

    public static void main(String[] args) {
    }
}

