#!/usr/bin/env python
import sys

import depwi as D

# 82248  9351 988      0      0    2    0    2      0    2    4    6
# 82248  9359 988      1      0    2    0    2      8   10   12   14
# 82248  9367 988      2      0    2    0    2     16   18   20   22
# 82248  9375 988      3      0    2    0    2     24   26   28   30

# The pattern variables are
# LLow Band, LHi0, LHi2, LHi4, LHi6, SRF0, SRF2, SRF4, SRF6 

g_ltRegPtrn = [
 ( 0, 0, 2,  0, 2,  0,  2,  4,  6),
 ( 1, 0, 2,  0, 2,  8, 10, 12, 14),
 ( 2, 0, 2,  0, 2, 16, 18, 20, 22),
 ( 3, 0, 2,  0, 2, 24, 26, 28, 30)
]

g_ltSfrPtrn = [
 ( 0,  2,  4,  6),
 ( 8, 10, 12, 14),
 (16, 18, 20, 22),
 (24, 26, 28, 30)
]

##############################################################################
def swap(sRec):

	lRec = list(sRec)
	
	for i in xrange(0, 442):
		cTmp = lRec[i*4]
		lRec[i*4] = lRec[i*4 + 3]
		lRec[i*4 + 3] = cTmp
			
		cTmp = lRec[i*4 + 1]
		lRec[i*4 + 1] = lRec[i*4 + 2]
		lRec[i*4 + 2] = cTmp
		
	sRec = "".join(lRec)
	return sRec

##############################################################################
def main(argv):
	perr = sys.stderr.write

	nRegPtrn = 0
	nLockPtrn = 0
	nIrregPtrn = 0

	for sFile in argv[1:]:
	
		nTotal = nRegPtrn + nIrregPtrn
		if nTotal > 0:
			print "INFO: Total records: %d, nominal records %d (%0.2f%%), off-nominal %d"%(
			      nTotal, nRegPtrn, (nRegPtrn*100.0)/nTotal, nIrregPtrn)
		
		perr("INFO: Reading %s\n"%sFile)
		
		fIn = file(sFile, 'rb')
		
		#print "Day   Sec   Mil   LLow   LHi0 LHi2 LHi4 LHi6   SFR0 SFR2 SFR4 SFR6"
		print "Day   Sec   Mil   SFR0 SFR2 SFR4 SFR6"
		#print "----- ----- ---   ----   ---- ---- ---- ----   ---- ---- ---- ----"
		print "----- ----- ---   ---- ---- ---- ----"
		
		sRec = fIn.read(442 * 4)
		nRecStart = 0
		while len(sRec) == 442*4:
		
			sRec = swap(sRec)
		
			t = D.getstatus(sRec)
			tSfrA = D.getsfr(sRec, 'A')
			tSfrB = D.getsfr(sRec, 'B')
			
			#tPtrn = (t[2], t[17], t[20], t[23], t[26], t[18], t[21], t[24], t[27])
			tPtrn = (t[18], t[21], t[24], t[27])
			
			if tPtrn in g_ltSfrPtrn:
				nRegPtrn += 1
			else:
				nIrregPtrn += 1
			
			nRecTime = t[0]*100000 + t[1] / 1000
			nSfrTime = 
			
			if [ t[18], t[21], t[24], t[27] ] == [0, 2, 4, 6]:
				nRecStart = t[0]*100000 + t[1] / 1000
			
			
			
			print "  "
			
			#print "%d %5d %3d   %4d   %4d %4d %4d %4d   %4d %4d %4d %4d"%(
			#       t[0], t[1]/1000, t[1]%1000, t[2], t[17], t[20], t[23], t[26],
			#		                   t[18], t[21], t[24], t[27])
			
			print "%d %5d %3d   %4d %4d %4d %4d"%(
			       t[0], t[1]/1000, t[1]%1000, t[18], t[21], t[24], t[27])
			
			sRec = fIn.read(442 * 4)

	nTotal = nRegPtrn + nIrregPtrn
	print "Total records: %d, nominal records %d (%0.2f%%), off-nominal %d"%(
	      nTotal, nRegPtrn, (nRegPtrn*100.0)/nTotal, nIrregPtrn)
	
	return 0
	
##############################################################################
# Kicker

if __name__ == "__main__":
	sys.exit( main(sys.argv) )
