#!/usr/bin/env python

import os
from distutils.core import setup, Extension
from os.path import join as pjoin

lScripts = []
lPkg = []

lSrc = ["src/pywrap.c"]
lInc = ['./src']
lExObj = [ pjoin( os.getenv("BUILD_DIR"), 'libdepwi.a') ]
lLib = ['gfortran']
lExtra = ['-O0']

setup(
   name="depwi",
	version="0.1",
	description="Dynamics Explorer 1: Plasma Wave Instrument processing",
	author="Chris Piker",
	ext_modules=[
	  Extension("depwi", sources=lSrc, include_dirs=lInc, extra_objects=lExObj,
	            libraries=lLib, extra_compile_args=lExtra)
	],
	author_email="chris-piker@uiowa.edu",
	url="https://saturn.physics.uiowa.edu/svn/de/production/"
)
	
