# Flags ######################################################################

FC= f77
FFLAGS=

#CC= gcc 
#CFLAGS= -Wall -std=c99 -O -I$(INST_INC)

#LIBS= -lgfortran -lm 

# Pattern Rules ##############################################################

$(BUILD_DIR)/%.o:src/%.c  | $(BUILD_DIR)
	$(CC) $(CFLAGS) -c $< -o $@

$(BUILD_DIR)/%.o:src/%.f | $(BUILD_DIR)
	$(FC) $(FFLAGS) -c $< -o $@

$(INST_NAT_BIN)/%:$(BUILD_DIR)/%
	install -D -m 775 $< $@
	
$(INST_NAT_LIB)/%:$(BUILD_DIR)/%
	install -D -m 664 $< $@
	
# Explicit Rules #############################################################

BD=$(BUILD_DIR)

# Keep *.o files around
#.PRECIOUS:$(BUILD_DIR)/%.o

build: $(BD)/de_pwi $(BD)/libdepwi.a

install:$(INST_NAT_BIN)/de_pwi $(INST_NAT_LIB)/libdepwi.a

$(BD):
	@if [ ! -d "$(BD)" ]; then mkdir $(BD); fi

$(BD)/de_pwi:$(BD)/pwi.o $(BD)/libdepwi.a
	$(FC) $(FFLAGS) -o $@ $^ $(LIBS4)
	
$(BD)/libdepwi.a: $(BD)/libr.o $(BD)/util.o
	ar -r $@ $^
 
clean:
	rm -f $(BD)/*.o

distclean:
	rm -r $(BD)
