/*
 * MakeIndexedDataSets.java
 *
 * Created on December 12, 2006, 11:52 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileDataSetDescriptor.SourceType;
import org.das2.components.DasProgressPanel;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.TimeUtil.TimeStruct;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.TimeParser;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystem.FileSystemOfflineException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Code for creating the indexed data sets using Brad's digitizing and
 * indexing.
 *
 * @author Jeremy
 */
public class MakeIndexedDataSets {

    String sc = "2";  // "1" or "2"

    private FileStorageModelNew getFSM(SourceType type) throws FileSystemOfflineException {
        FileSystem fs;
        try {
            fs = FileSystem.create(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/" + type.dir + "/"));
        } catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        return FileStorageModelNew.create(fs, "v" + sc + "den%Y%j.data");
    }

    /**
     * returns the range covered by all the data files.  We'll break this up into
     * days and loop over days.
     */
    private DatumRange getDataSetRange() throws IOException {
        DatumRange result = null;
        for (Iterator it = DensityFileDataSetDescriptor.sourceTypeInstances.values().iterator(); it.hasNext();) {
            Object st = it.next();
            FileStorageModelNew fsm = getFSM((SourceType) st);
            String[] names = fsm.getNamesFor(DatumRangeUtil.parseTimeRangeValid("1960-2009"));
            for (int i = 0; i < names.length; i++) {
                DatumRange r1 = fsm.getRangeFor(names[i]);
                if (result == null) {
                    result = r1;
                } else {
                    result = result.include(r1.min()).include(r1.max());
                }
            }
        }
        return result;
    }

    private VectorDataSet getIndexDS() throws MalformedURLException, FileSystemOfflineException, FileNotFoundException, ParseException, IOException {

        EnumerationUnits u = new EnumerationUnits("digitizeType");

        final HashMap colors = new HashMap();
        u.createDatum("L");
        u.createDatum("R");
        u.createDatum("P");

        FileSystem fs;
        fs = FileSystem.create(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/index/"));

        File file= fs.getFileObject("v" + sc + "index_20080807.txt").getFile();
        BufferedReader reader = new BufferedReader(new FileReader( file ));

        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.us1980, u);
        builder.addPlane("width", Units.seconds);

        TimeParser tparser = TimeParser.create(TimeParser.TIMEFORMAT_Z);

        String line = "";
        while (line != null) {
            if (!(line.startsWith("#") || line.equals(""))) {
                String[] ss = line.split("\\s+");
                Datum x = tparser.parse(ss[0]).getTimeDatum();
                Datum y = u.createDatum(ss[1]);
                Datum w = Units.seconds.parse(ss[2]);
                builder.insertY(x, y, "");
                builder.insertY(x, w, "width");
            }
            line = reader.readLine();
        }

        reader.close();

        return builder.toVectorDataSet();
    }

    private void doit() throws FileSystemOfflineException, MalformedURLException, FileNotFoundException, ParseException, IOException {

        DatumRange dataSetRange = getDataSetRange();

        VectorDataSet indexDs = getIndexDS();
        VectorDataSet widths = (VectorDataSet) indexDs.getPlanarView("width");

        ProgressMonitor mon = DasProgressPanel.createFramed("indexed dataset");

        mon.setTaskSize(indexDs.getXLength());
        mon.started();

        Datum lastTime;
        lastTime = dataSetRange.min();

        DatumRange debug= DatumRangeUtil.parseTimeRange("1979-060 21:35:48.500 span 1 s" );

        
        for (int i = 0; i < indexDs.getXLength() + 1; i++) {
            DatumRange dr;
            Datum type;
            SourceType tt;

            mon.setTaskProgress(i);

            Datum nextTime = i == indexDs.getXLength() ? dataSetRange.max() : indexDs.getXTagDatum(i);
        
            // do implicit P type, between Brad's ranges.
            if (nextTime.gt(lastTime)) {
                dr = new DatumRange(lastTime, nextTime );
                System.err.println("implicit: " + dr);
                doDayImplicit(dr);
            }

            if (i < indexDs.getXLength()) {
                dr = new DatumRange(indexDs.getXTagDatum(i), indexDs.getXTagDatum(i).add(widths.getDatum(i)));

                type = indexDs.getDatum(i);
                tt = (SourceType) DensityFileDataSetDescriptor.sourceTypeInstances.get(type.toString());

                FileStorageModelNew fsm = getFSM(tt);
                File[] ff = fsm.getFilesFor(dr);

                for (int j = 0; j < ff.length; j++) {
                    doDay(dr, ff[j]);
                }

                lastTime = dr.max();
            }

        }
        mon.finished();

    }

    /**
     * check each type for records where only one digitize type is used.  When multiple
     * are found, P is to be used.
     * @param dr
     */
    private void doDayImplicit(DatumRange dr) throws FileSystemOfflineException, FileNotFoundException, ParseException, IOException {
        int nrec = (int) dr.width().doubleValue(Units.seconds) + 1;
        String[] values = new String[nrec];

        SourceType[] types = new SourceType[]{
            DensityFileDataSetDescriptor.L_SOURCE_TYPE,
            DensityFileDataSetDescriptor.R_SOURCE_TYPE,
            DensityFileDataSetDescriptor.U_SOURCE_TYPE,
            DensityFileDataSetDescriptor.P_SOURCE_TYPE
        };


        TimeParser tparser = TimeParser.create("%Y %j %H %M %S.%{milli}");
        
        for (int i = 0; i < types.length; i++) {
            SourceType tt = types[i];
            FileStorageModelNew fsm = getFSM(tt);
            File[] ff = fsm.getFilesFor(dr);
            for (int j = 0; j < ff.length; j++) {
                File file = ff[j];
                
                BufferedReader reader = new BufferedReader(new FileReader(file));

                String line = "";
                while (line != null) {
                    if (!(line.startsWith("#") || line.equals(""))) {
                        Datum td = tparser.parse(line.substring(0, 21)).getTimeDatum();
                        if (dr.contains(td)) {
                            int idx = (int) (td.subtract(dr.min()).doubleValue(Units.seconds));
                            values[idx] = line;
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
        }
        
        Datum f0= dr.min();
        Datum f1= TimeUtil.next( TimeUtil.DAY, f0 );
        
        
        while ( f0.lt(dr.max() ) ) {
            DatumRange fdr= new DatumRange( f0,f1 );

            TimeStruct ts= TimeUtil.toTimeStruct(f0);
            String outName=  "v" + sc + String.format( "den%04d%03d.data", ts.year, ts.doy );
            
            
            File root = new File("/home/jbf/sun/public_html/voyager/index_data_temp/" + outName);
        
            Datum d0= dr.min().gt( f0 ) ? dr.min() : f0;
            Datum d1= dr.max().lt( f1 ) ? dr.max() : f1;
            int idx0= (int) (d0.subtract( dr.min() )).doubleValue(Units.seconds);
            int idx1= (int) (d1.subtract( dr.min() )).doubleValue(Units.seconds)+1;

            BufferedWriter writer;
            if (root.exists()) {
                writer = new BufferedWriter(new FileWriter(root, true));
            } else {
                writer = new BufferedWriter(new FileWriter(root));
            }
            
            int n= 0; 
            for (int i = idx0; i < idx1; i++) {
                if (values[i] != null) {
                    writer.write(values[i] + "\n");
                    n++;
                }
            }
            writer.close();
            if ( root.length()==0 ) root.delete();
            
            f0= TimeUtil.next( TimeUtil.DAY, f0 );
            f1=  TimeUtil.next( TimeUtil.DAY, f0 );
        }
    }

    private void doDay(DatumRange dr, File file) throws IOException, ParseException {
        File root = new File("/home/jbf/sun/public_html/voyager/index_data_temp/" + file.getName());
        BufferedWriter writer;
        if (root.exists()) {
            writer = new BufferedWriter(new FileWriter(root, true));
        } else {
            writer = new BufferedWriter(new FileWriter(root));
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));

        TimeParser tparser = TimeParser.create("%Y %j %H %M %S.%{milli}");

        String line = "";
        while (line != null) {
            if (!(line.startsWith("#") || line.equals(""))) {
                if (dr.contains(tparser.parse(line.substring(0, 21)).getTimeDatum())) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            line = reader.readLine();
        }
        writer.close();
        reader.close();
    }

    public static void main(String[] args) throws FileSystemOfflineException, MalformedURLException, FileNotFoundException, ParseException, IOException {
        new MakeIndexedDataSets().doit();
    }
}
