/*
 * LocalFileReaderPanel.java
 *
 * Created on November 9, 2006, 12:39 PM
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author  Jeremy
 */
public class LocalFileReaderPanel extends javax.swing.JPanel {
    
    VoyagerHighRate app;
    HighRateFilesDataLoader loader;
    
    /** Creates new form LocalFileReaderPanel */
    public LocalFileReaderPanel( VoyagerHighRate app ) {
        this.app= app;
        initComponents();
        loader= new HighRateFilesDataLoader( app.renderer );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        useLocalCB = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        datasetSelect = new javax.swing.JComboBox();
        jButton1 = new javax.swing.JButton();
        updateButton = new javax.swing.JButton();

        useLocalCB.setText("Use local reader");
        useLocalCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        useLocalCB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        useLocalCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useLocalCBActionPerformed(evt);
            }
        });

        jLabel1.setText("High Rate Spectrogram Options:");

        datasetSelect.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-fft3x512av", "-fft3x512", "-fft1600" }));
        datasetSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                datasetSelectActionPerformed(evt);
            }
        });

        jButton1.setText("Choose files...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        updateButton.setText("Load Data");
        updateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(datasetSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jButton1)
                    .add(useLocalCB)
                    .add(jLabel1)
                    .add(updateButton))
                .addContainerGap(235, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(useLocalCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(datasetSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(updateButton)
                .addContainerGap(168, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void updateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateButtonActionPerformed
        loader.doLoad();
    }//GEN-LAST:event_updateButtonActionPerformed

    private void datasetSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_datasetSelectActionPerformed
        HighRateFilesDataLoader.FftAvg[] mm= new HighRateFilesDataLoader.FftAvg[] {
            HighRateFilesDataLoader.FftAvg.fft512x3av, HighRateFilesDataLoader.FftAvg.fft512x3,
            HighRateFilesDataLoader.FftAvg.fft1600 };
        loader.setFftMethod( mm[datasetSelect.getSelectedIndex()] );
    }//GEN-LAST:event_datasetSelectActionPerformed
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        useLocalCB.setSelected(true);
        useLocalCB.setEnabled( false );
        Preferences prefs= Preferences.userNodeForPackage(this.getClass());
        String currentDirectoryPath= prefs.get( "loadRoot", new File("").getAbsolutePath().toString() );
        JFileChooser chooser= new JFileChooser( currentDirectoryPath  );
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter( new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".DAT");
            }
            public String getDescription() {
                return "*.DAT";
            }
        } );
        if ( chooser.showOpenDialog( this )== JFileChooser.APPROVE_OPTION ) {
            prefs.put( "loadRoot", chooser.getCurrentDirectory().toString() );
            final File[] files= chooser.getSelectedFiles();
            
            loader.setFiles( files );
            app.setUseLocal(true);
        }
    
    }//GEN-LAST:event_jButton1ActionPerformed

    private void useLocalCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useLocalCBActionPerformed
        if ( useLocalCB.isSelected() ) {
            useLocalCB.setEnabled( false );
            app.setUseLocal(true);
        }
    }//GEN-LAST:event_useLocalCBActionPerformed
    
    /**
     * set the state of the panel for local access.
     */
    void setUseLocal(boolean b) {
        if ( !b ) throw new IllegalArgumentException( "only true supported--sorry" );
        useLocalCB.setSelected( true );
        useLocalCB.setEnabled( false );
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox datasetSelect;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton updateButton;
    private javax.swing.JCheckBox useLocalCB;
    // End of variables declaration//GEN-END:variables
    
}
