/*
 * LauncherApplet.java
 *
 * Created on October 30, 2006, 1:35 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystem.FileSystemOfflineException;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/**
 *
 * @author Jeremy
 */
public class LauncherApplet extends javax.swing.JApplet {
    
    /**
     * true if waiting for initial time.
     */
    boolean waiting= true;
    
    JFrame appFrame;
    VoyagerHighRate app;
    File localRootFile;
    File localFile;
    URL localRootURL;
    
    public LauncherApplet() {
    }
    
    public void setLocalFileWeb( final String name ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                try {
                    setLocalFileWebImmediately( name );
                } catch (FileSystem.FileSystemOfflineException ex) {
                    ex.printStackTrace();
                }
            }
        } );
    }
    
    /**
     * note the applet actually sends the data file
     */
    protected void setLocalFileWebImmediately( final String name ) throws FileSystemOfflineException {
        
        if ( app == null ) {
            launch( );
        } else {
            appFrame.setVisible(true);
        }
        
        FileSystem fs= FileSystem.create(localRootURL);
        File file=null;
        
        String pngFileName = name;
        pngFileName= pngFileName.replace("BROWSE/", "DATA/");
        pngFileName= pngFileName.substring(0,pngFileName.length()-4)+".DAT";
        
        FileObject fo= fs.getFileObject(pngFileName);
        try {
            ProgressMonitor mon= DasApplication.getDefaultApplication()
            .getMonitorFactory().getMonitor( app.getPlot(),
                    "loading file", "loading data file over http" );
            
            file= fo.getFile( mon );
        } catch (FileNotFoundException ex) {
            DasExceptionHandler.handle(ex);
        } catch ( IOException ex )  {
            DasExceptionHandler.handle(ex);
        }
        
        app.setLocalFile( new File[] { file } );
        localFile= file;
        waiting= false;
        repaint();
    }
    
    /**
     * set the application to load and display the data for the given filename.  Note
     * the root should be set already.
     */
    public void setLocalFile( final String pngFileName ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                setLocalFileImmediately( pngFileName );
            }
        } );
    }
    
    private void setLocalFileImmediately( String pngFileName ) {
        if ( localRootFile==null ) {
            throw new RuntimeException("docbase is not a file://");
        }
        pngFileName= pngFileName.replace("BROWSE/", "DATA/");
        final File dataFile= new File( localRootFile, 
				pngFileName.substring(0,pngFileName.length()-4)+".DAT" );
        
        if ( app == null ) {
            launch( );
        } else {
            appFrame.setVisible(true);
        }
        
        app.setLocalFile( new File[] { dataFile } );
        localFile= dataFile;
        waiting= false;
        repaint();
        
    }
    
    private File getDirectoryFromDocBaseURL( URL docBase, String localRoot ) {
        
        //System.err.println("docBase="+docBase);
        String surl= docBase.toString();
        
        //solaris/mozilla  file:/home/jbf/VGPW_0101_1/EXTRAS/VG1_1983.HTM
        String string= surl.substring("file:".length() );
        
        //kludge for Windows  file:/J:/VGPW_0101_1/EXTRAS/VG1_1983.HTM
        int idx= string.indexOf(":");
        if ( idx != -1 ) {
            string= string.substring( idx-1 );
        }
        
        // docbase includes HTM file.
        if ( string.endsWith("HTM") ) {
            idx= string.lastIndexOf("/");
            string= string.substring(0,idx);
        }
        
        //System.err.println( "docBaseFile="+string);
        //System.err.println( "localRoot="+localRoot );
        File docBaseFile= new File( string );
        
        File result;
        try {
            result= new File( docBaseFile, localRoot );
            //System.err.println("result="+result);
            result= result.getCanonicalFile();
            return result;
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
    
    private void launch( ) {
        appFrame= new JFrame();
        app= new VoyagerHighRate( true, appFrame );
        app.renderer.getZAxis().setDatumRange( 
				new DatumRange( 0.00001000, 0.1, Units.dimensionless ) );
        appFrame.pack();
        appFrame.setVisible(true);
        appFrame.setDefaultCloseOperation( JFrame.HIDE_ON_CLOSE );
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor( Color.DARK_GRAY );
        g.fillRect(0,0,getWidth(),getHeight());
        g.setColor( Color.white );
        if ( waiting ) {
            //g.drawString( "waiting", 10, 10 );
        } else {
            //g.drawString( "NOT WAITING", 10, 10 );
        }
    }
    
    public void destroy() {
        super.destroy();
        if ( appFrame!=null ) appFrame.dispose();
    }
    
    public void init() {
        super.init();
        DasApplication.getDefaultApplication().setApplet( true );
        DasApplication.getDefaultApplication().setHeadless( false );
        
        String localRoot= getParameter( "root" );
        if ( localRoot==null ) {
            localRoot= "../..";
        }
        
        URL docBase= getDocumentBase();
        /*if ( !docBase.getProtocol().equals("file") ) {
            String msg= "docBase protocol must be file://, not "+docBase.getProtocol()+"//";
            JOptionPane.showMessageDialog( this, msg );
            throw new RuntimeException( msg );
        }*/
        
        if ( localRoot.startsWith("/") || localRoot.charAt(1)==':' ) {
            localRootFile= new File( localRoot );
        } else {
            if ( docBase.getProtocol().equals("file") ) {
                localRootFile= getDirectoryFromDocBaseURL( docBase, localRoot );
            } else {
                localRootFile= null;
            }
            try {
                localRootURL= new URL( docBase, localRoot );
            } catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        
        //debuggerHelper();
    }
    
    
    /***********************************************/
    /* below is testing stuff                      */
    /***********************************************/
    private JFrame debuggerHelper() {
        JFrame f= new JFrame("debuggerHelper");
        
        Box vertPanel= new Box( BoxLayout.Y_AXIS );
        
        vertPanel.add( new JButton( new AbstractAction("setTimePart") {
            public void actionPerformed(ActionEvent e) {
                setLocalFileWeb( "BROWSE/P6/V20721/C1178858.PNG" );
            }
        }) );
        
        vertPanel.add( new JButton( new AbstractAction("setTimePart2") {
            public void actionPerformed(ActionEvent e) {
                setLocalFileWeb( "BROWSE/P6/V20721/C1189328.PNG" );
            }
        }) );
        
        f.getContentPane().add( vertPanel );
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation( JFrame.HIDE_ON_CLOSE );
        return f;
    }
    
    static class MyAppletStub implements AppletStub {
        HashMap params;
        
        MyAppletStub() {
            params= new HashMap();
            params.put("root","../..");
        }
        
        public void appletResize(int param, int param1) {
            
        }
        
        public AppletContext getAppletContext() {
            return null;
        }
        
        public java.net.URL getCodeBase() {
            return null;
        }
        
        public java.net.URL getDocumentBase() {
            try {
                //return new URL("file://J:/VGPW_1011/EXTRAS/");
                return new URL("http://www-pw.physics.uiowa.edu/~jbf/VGPW_2007/EXTRAS/HTML/");
            } catch ( MalformedURLException e ) {
                throw new RuntimeException(e);
            }
        }
        
        public String getParameter(String str) {
            return (String)params.get(str);
        }
        
        public boolean isActive() {
            return true;
        }
    }
    
    public static void main( String[] args ) {
        
        Applet applet= new LauncherApplet();
        applet.setStub( new MyAppletStub() );
        
        JFrame frame= new JFrame("Applet");
        
        frame.setContentPane(applet);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        applet.init();
        applet.start();
    }
    
}
