/*
 * IndexedDensityFileDataSetDescriptor.java
 *
 * Created on October 9, 2006, 5:03 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

//import edu.uiowa.physics.pw.apps.vgpws.hr.DensityFileDataSetDescriptor.PlaneType;
//import edu.uiowa.physics.pw.apps.vgpws.hr.DensityFileDataSetDescriptor.SourceType;
import org.das2.DasException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.ClippedVectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.filesystem.FileSystem;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Jeremy
 */
public class IndexedDensityFileDataSetDescriptor extends DataSetDescriptor {
    
    String voyagerNum;
    DensityFileDataSetDescriptor.PlaneType planeType;
    VectorDataSet index;
    
    public IndexedDensityFileDataSetDescriptor( String voyagerNum, DensityFileDataSetDescriptor.PlaneType planeType,
			                                VectorDataSet index ) {
        this.planeType= planeType;
        this.index= index;
        this.voyagerNum= voyagerNum;
    }
    
    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        try {
            
            Datum t= start;
            String defaultType="p";  // default
            String currentType= defaultType;
            Map datasets= new HashMap();
            
            if ( index==null ) {
                DensityFileDataSetDescriptor.SourceType stype= 
							 (DensityFileDataSetDescriptor.SourceType) DensityFileDataSetDescriptor.sourceTypeInstances.get(currentType);
                DataSetDescriptor dsd;
                
                dsd = new DensityFileDataSetDescriptor(voyagerNum, stype, planeType);
                DataSet ds= (VectorDataSet) dsd.getDataSet( start, end, resolution, ProgressMonitor.NULL );
                datasets.put( currentType, ds );
                
                return ds;
            }
            
            EnumerationUnits units= (EnumerationUnits) index.getYUnits();
            
            VectorDataSet widthsDs= (VectorDataSet) index.getPlanarView("width");
            
            VectorDataSetBuilder builder= new VectorDataSetBuilder( Units.us2000, Units.hertz );
            
            DatumRange current;
            
            while ( t.lt(end) ) {
                int i= DataSetUtil.getPreviousColumn(index,t);
                if ( i<index.getXLength()-1 && index.getXTagDatum(i+1).equals(t) ) i++;
                
                Datum w= widthsDs.getDatum(i);
                DatumRange test= new DatumRange( index.getXTagDatum(i), index.getXTagDatum(i).add(w) );
                
                if ( test.contains(t) ) { // note dr.contains(dr.max())==false
                    currentType= (String)units.getObject( index.getDatum(i) );
                    current= test;
                } else {
                    currentType= defaultType;
                    Datum endt;
                    if ( test.min().gt(t) ) {
                        endt= test.min();
                    } else {
                        if ( i< index.getXLength()-1 ) {
                            endt= index.getXTagDatum(i+1);
                        } else {
                            endt= end;
                        }
                    }
                    current= new DatumRange( t, endt );
                }
                
                
                VectorDataSet ds= (VectorDataSet) datasets.get(currentType);
                if ( ds==null ) {
                    DensityFileDataSetDescriptor.SourceType stype= 
								  (DensityFileDataSetDescriptor.SourceType) DensityFileDataSetDescriptor.sourceTypeInstances.get(currentType);
                    DataSetDescriptor dsd;
                    
                    dsd = new DensityFileDataSetDescriptor(voyagerNum, stype, planeType);
                    ds= (VectorDataSet) dsd.getDataSet( start, end, null, ProgressMonitor.NULL );
                    datasets.put( currentType, ds );
                }
                
                if ( ds!=null ) {
                    builder.append( new ClippedVectorDataSet( ds, current ) );
                }
                t= current.max();
                
            }
            
            builder.setProperty( DataSet.PROPERTY_CACHE_TAG, new CacheTag( start, end, null ) );
            
            return builder.toVectorDataSet();
            
        } catch (FileSystem.FileSystemOfflineException ex) {
            throw new RuntimeException(ex);
        }
    }
    
    public Units getXUnits() {
        return Units.us2000;
    }
    
    
}
