/*
 * IndexTool.java
 *
 * Created on October 9, 2006, 2:03 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.components.DataPointRecorder;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.EventsRenderer;
import java.awt.Color;
import java.util.HashMap;
import javax.swing.JFrame;

/**
 *
 * @author Jeremy
 */
public class IndexTool {
    
    EventsRenderer renderer;
    DataPointRecorder recorder;
    
    EnumerationUnits typeUnits= new EnumerationUnits("digitizeType");
    final HashMap typeColorMap= new HashMap();
    {
        typeColorMap.put( typeUnits.createDatum("R"), Color.RED );
        typeColorMap.put( typeUnits.createDatum("u"), Color.BLUE );
        typeColorMap.put( typeUnits.createDatum("L"), Color.GREEN );
        typeColorMap.put( typeUnits.createDatum("p"), Color.ORANGE );
    }
    
    IndexTypeDialog typePopup;
    
    /**
     * round the datum range to descretized values by rounding outward.
     */
    DatumRange descretize( DatumRange dr, Datum base, Datum granularity ) {
        base= base.convertTo( dr.getUnits() ); // result should be in the same units as input dr.
        Units u= dr.getUnits().getOffsetUnits();
        double min= dr.min().subtract(base).doubleValue( u );
        double max= dr.max().subtract(base).doubleValue( u );
        double dd= granularity.doubleValue( u );
        Datum dmin= base.add( u.createDatum( Math.floor( min / dd ) * dd ) );
        Datum dmax= base.add( u.createDatum( Math.ceil( max / dd ) * dd ) );
        return new DatumRange( dmin, dmax );
    }
    
    BoxSelectionListener listener= new BoxSelectionListener() {
        public void BoxSelected( BoxSelectionEvent e) {
            DatumRange range= descretize( e.getXRange(), Units.us2000.createDatum(0), recorder.getXTagWidth() ); 
            
            typePopup.setVisible(true);
            int r= typePopup.getReturnStatus();
            if ( r!=typePopup.RET_OK ) return;
            String type= typePopup.getIndexType();
            
            VectorDataSetBuilder builder= new VectorDataSetBuilder( range.getUnits(), typeUnits );
            builder.addPlane( "width", Units.seconds );
            
            builder.insertY( range.min(), typeUnits.createDatum(type) );
            builder.insertY( range.min(), range.width(), "width" );
            
            recorder.appendDataSet(builder.toVectorDataSet());
        }
    };
    
    DataSetUpdateListener dataListener= new DataSetUpdateListener() {
        public void dataSetUpdated(DataSetUpdateEvent e) {
            DataSet ds= recorder.getDataSet();
            renderer.setDataSet(ds);
        }
    };
    
    IndexTool( DasPlot p, JFrame appFrame ) {
        DasRow typeRow= new DasRow( null, p.getRow(), 1., 1., 0, 0, 0, 5 );
        
        p.getXAxis().setVisible(false);
        
        DasAxis yAxis= new DasAxis( new DatumRange( 0,1, Units.dimensionless ), DasAxis.VERTICAL );
        yAxis.setVisible(false);
        
        DasPlot ind= new DasPlot( p.getXAxis().createAttachedAxis(), yAxis );
        renderer= new EventsRenderer();
        
        renderer.setColorSpecifier( new EventsRenderer.ColorSpecifier() {
            public Color getColor(Datum d) {
                return (Color)typeColorMap.get(d);
            }
        } );
        
        renderer.setWidthPlaneId( "width" );
        
        ind.addRenderer( renderer );
        
        p.getCanvas().add( ind, typeRow, p.getColumn() );
        p.getCanvas().revalidate();
        
        recorder= new DataPointRecorder(  );
        
        recorder.setXTagWidth( Units.milliseconds.createDatum(500) );

        recorder.addDataSetUpdateListener(dataListener);
        
        BoxSelectorMouseModule mm= new BoxSelectorMouseModule(
                p,
                p.getXAxis(),
                null,
                renderer,
                new BoxRenderer(p,false), "Index Select" );
        
        mm.addBoxSelectionListener( listener );
        
        p.addMouseModule( mm );
        typePopup= new IndexTypeDialog( appFrame, true );
    }
    
    DataPointRecorder getRecorder() {
        return recorder;
    }
}
