/*
 * HROptionsPanel.java
 *
 * Created on October 24, 2006, 4:38 PM
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

/**
 *
 * @author  Jeremy
 */
public class HROptionsPanel extends javax.swing.JPanel {
    
    VoyagerHighRate app;
    /** Creates new form HROptionsPanel */
    public HROptionsPanel( VoyagerHighRate app ) {
        initComponents();
        if ( app.localOnly ) drawIndexedFceOverlayCB.setVisible(false);
        this.app= app;
        DigitizerOverlaysSelector sel= new DigitizerOverlaysSelector( app, this );
        overlaysSelectorPanelContainer.add( sel.getPanel() );
        overlaysSelectorPanelContainer.revalidate();
    }
    
    public boolean isVoyager1() {
        return spacecraftSelect.getSelectedItem().equals("Voyager 1");
    }

    public static final String PROP_VOYAGER1 = "voyager1";

    
    String getSpectrogramDataSetID() {
        return "http://www-pw.physics.uiowa.edu/das/das2Server?"
                + ( isVoyager1() ? "voyager1" : "voyager2" )
                + "/pws/wf-ps"
                + datasetSelect.getSelectedItem()
                + ( cleanCB.isSelected() ? "-clean" : "" );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jCheckBox1 = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        spacecraftSelect = new javax.swing.JComboBox();
        datasetSelect = new javax.swing.JComboBox();
        cleanCB = new javax.swing.JCheckBox();
        drawHighRateSpectrogramCB = new javax.swing.JCheckBox();
        drawCyclotronFrequencyCB = new javax.swing.JCheckBox();
        drawIndexedFceOverlayCB = new javax.swing.JCheckBox();
        showLegendCB = new javax.swing.JCheckBox();
        overlaysSelectorPanelContainer = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("Use das2Server");
        jCheckBox1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jLabel1.setText("High Rate Spectrogram Options:");

        spacecraftSelect.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Voyager 1", "Voyager 2" }));
        spacecraftSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                spacecraftSelectActionPerformed(evt);
            }
        });

        datasetSelect.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-fft3x512av", "-fft3x512", "-fft1600" }));

        cleanCB.setText("-clean");
        cleanCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        drawHighRateSpectrogramCB.setText("draw high rate spectrogram ");
        drawHighRateSpectrogramCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        drawHighRateSpectrogramCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drawHighRateSpectrogramCBActionPerformed(evt);
            }
        });

        drawCyclotronFrequencyCB.setText("draw cyclotron frequency");
        drawCyclotronFrequencyCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        drawCyclotronFrequencyCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drawCyclotronFrequencyCBActionPerformed(evt);
            }
        });

        drawIndexedFceOverlayCB.setText("draw indexed fce overlay");
        drawIndexedFceOverlayCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        drawIndexedFceOverlayCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drawIndexedFceOverlayCBActionPerformed(evt);
            }
        });

        showLegendCB.setSelected(true);
        showLegendCB.setText("show legend");
        showLegendCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        showLegendCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showLegendCBActionPerformed(evt);
            }
        });

        overlaysSelectorPanelContainer.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        overlaysSelectorPanelContainer.setLayout(new java.awt.BorderLayout());

        jLabel2.setText("Digitized data overlays:");

        jButton1.setText("Update Spectrogram Options");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jCheckBox1)
                    .add(jLabel1)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(drawCyclotronFrequencyCB)
                            .add(drawIndexedFceOverlayCB)
                            .add(showLegendCB)
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jButton1)
                                    .add(spacecraftSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(datasetSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(cleanCB)))
                            .add(drawHighRateSpectrogramCB))
                        .add(17, 17, 17)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(overlaysSelectorPanelContainer, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 225, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jLabel2))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jCheckBox1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(spacecraftSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(datasetSelect, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cleanCB)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButton1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(drawHighRateSpectrogramCB)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(drawCyclotronFrequencyCB)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(drawIndexedFceOverlayCB)
                        .add(21, 21, 21)
                        .add(showLegendCB))
                    .add(overlaysSelectorPanelContainer, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 202, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        app.update();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void showLegendCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showLegendCBActionPerformed
        app.legend.setVisible( showLegendCB.isSelected() );
    }//GEN-LAST:event_showLegendCBActionPerformed
    
    private void drawIndexedFceOverlayCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drawIndexedFceOverlayCBActionPerformed
        app.indexedRenderer.setActive( drawIndexedFceOverlayCB.isSelected() );
        if ( drawIndexedFceOverlayCB.isSelected() ) {
            app.legend.add( app.indexedRenderer, "indexed fce" );
            app.updateIndexed();
        } else {
            app.legend.remove( app.indexedRenderer );
        }
    }//GEN-LAST:event_drawIndexedFceOverlayCBActionPerformed
    
    private void drawCyclotronFrequencyCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drawCyclotronFrequencyCBActionPerformed
        app.cycloRenderer.setActive( drawCyclotronFrequencyCB.isSelected() );
        if ( drawCyclotronFrequencyCB.isSelected() ) {
            app.legend.add( app.cycloRenderer, "cyclotron" );
        } else {
            app.legend.remove( app.cycloRenderer );
        }
    }//GEN-LAST:event_drawCyclotronFrequencyCBActionPerformed
    
    private void drawHighRateSpectrogramCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drawHighRateSpectrogramCBActionPerformed
        app.renderer.setActive(  drawHighRateSpectrogramCB.isSelected() );
    }//GEN-LAST:event_drawHighRateSpectrogramCBActionPerformed

    private void spacecraftSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_spacecraftSelectActionPerformed
        firePropertyChange( PROP_VOYAGER1, !isVoyager1(), isVoyager1() );
    }//GEN-LAST:event_spacecraftSelectActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cleanCB;
    private javax.swing.JComboBox datasetSelect;
    private javax.swing.JCheckBox drawCyclotronFrequencyCB;
    private javax.swing.JCheckBox drawHighRateSpectrogramCB;
    private javax.swing.JCheckBox drawIndexedFceOverlayCB;
    private javax.swing.JButton jButton1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel overlaysSelectorPanelContainer;
    private javax.swing.JCheckBox showLegendCB;
    private javax.swing.JComboBox spacecraftSelect;
    // End of variables declaration//GEN-END:variables
    
}
