/*
 * FileIndex.java
 *
 * Created on October 31, 2006, 4:16 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.util.TimeParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Jeremy
 */
public class FileIndex {
    File localRoot;
    
    FileIndex( File localRoot ) {
        this.localRoot= localRoot;
    }
    
    /**
     * returns the number of files in the interval.  The two Lists are 
     * populated with the volume ids and files within each volume.
     * @param range the range to search for.
     * @param volumes List<String> that is populated with volume IDs.
     * @param files List<String> that contans the files.
     */
    int getFiles( DatumRange range, List volumes, List files ) throws IOException, ParseException {
        File cumIndex= new File( localRoot, "INDEX/CUMINDEX.TAB" );
        BufferedReader reader= new BufferedReader( new FileReader( cumIndex ) );
        String s= reader.readLine(); 
        TimeParser tparser= TimeParser.create( "%Y-%jT%H:%M:%S.%{milli}" );
        int t0= 29;
        int t1= 51;
        int f0= 67;
        int f1= 99;
        ArrayList result= new ArrayList();
        while ( s!=null ) {
            Datum begin= tparser.parse( s.substring(t0,t1) ).getTimeDatum();
            if ( range.contains(begin) ) {
                files.add( s.substring(f0,f1) );
                volumes.add( s.substring( 1, 10 ) );
            }
        }
        reader.close();
        return volumes.size();
    }
}
