/*
 * EZVectorDataSet.java
 *
 * Created on April 15, 2005, 2:59 PM
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.dataset.VectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import java.util.HashMap;

/**
 *
 * @author Jeremy
 */

public abstract class EZVectorDataSet implements VectorDataSet {
    protected java.util.Map properties= new java.util.HashMap();
    String[] planeIds= new String[0];
    
    public Datum getDatum(int i) {
        Units yUnits= getYUnits();
        return yUnits.createDatum( getDouble(i,yUnits) );
    }
    
    abstract public double getDouble(int i, Units units );
    
    public int getInt(int i, Units units) {
        return (int) getDouble( i,units );
    }
    
    public DataSet getPlanarView(String planeID) {
        return planeID.equals("") ? this : null;
    }
    
    public String[] getPlaneIds() {
        return planeIds;
    }
    
    public java.util.Map getProperties() {
        return new HashMap( properties );
    }
    
    public Object getProperty(String name) {
        return properties.get(name);
    }
    
    abstract public int getXLength();
    
    public Datum getXTagDatum(int i) {
        Units xUnits= getXUnits();
        return xUnits.createDatum( getXTagDouble(i,xUnits) );
    }
    
    abstract public double getXTagDouble(int i, Units units);
    
    public int getXTagInt(int i, Units units) {
        return (int)getXTagDouble( i, units );
    }
    
    abstract public Units getXUnits();
    
    abstract public Units getYUnits();
}