/*
 * DigitizerOverlaysSelector.java
 *
 * Created on October 24, 2006, 4:50 PM
 *
 *
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.SeriesRenderer;
import org.das2.util.DasExceptionHandler;
import edu.uiowa.physics.pw.pds.PdsVolume;
import java.io.IOException;
import org.das2.util.filesystem.FileSystem.FileSystemOfflineException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pds.label.PDSException;

/**
 * Implements the grid of overlay selections.
 * @author Jeremy
 */
public class DigitizerOverlaysSelector {

    JPanel overlaysPanel;
    VoyagerHighRate app;
    HROptionsPanel optionsPanel;
    private float lastHue = -0.07f;

    private Color getNextNonColorbarColor() {
        lastHue += 0.07f;
        return Color.getHSBColor(lastHue, 0.8f, 0.8f);
    }

    public JPanel getPanel() {
        return overlaysPanel;
    }
    PropertyChangeListener listener = new PropertyChangeListener() {

        public void propertyChange(PropertyChangeEvent evt) {
            DigitizerOverlaysSelector.this.refresh();
        }
    };

    private Component getOverlaySelector(final DensityFileDataSetDescriptor.SourceType source, final DensityFileDataSetDescriptor.PlaneType plane) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
        final JCheckBox cb = new JCheckBox();
        result.add(cb);
        final JLabel symLabel = new JLabel();
        result.add(symLabel);
        cb.setAction(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                String key = source.toString() + ":" + plane.toString();
                if (cb.isSelected()) {
                    SeriesRenderer r = (SeriesRenderer) app.overlayRenderers.get(key);
                    if (r == null) {
                        try {
                            r = new SeriesRenderer();
                            r.setLineWidth(1.0);
                            r.setPsym(DefaultPlotSymbol.NONE);
                            r.addPropertyChangeListener(listener);
                            DataSetDescriptor dsd;
                            if ( source==DensityFileDataSetDescriptor.PDS_SOURCE_TYPE ) {
                                PdsVolume vol= new PdsVolume(new URL("file:///opt/project/voyager/pds/VGPW_0201/") );
                                //PdsVolume vol= new PdsVolume(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/VGPW_0201/") );
                                dsd= new VgDensDataDSD( vol, optionsPanel.isVoyager1() ? 1 : 2, plane );
                            } else if ( source==DensityFileDataSetDescriptor.PDS_HTTP_SOURCE_TYPE ) {
                                //PdsVolume vol= new PdsVolume(new URL("file:///opt/project/voyager/pds/VGPW_0201/") );
                                PdsVolume vol= new PdsVolume(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/VGPW_0201/") );
                                dsd= new VgDensDataDSD( vol, optionsPanel.isVoyager1() ? 1 : 2, plane ); 
                            } else {
                                dsd= new DensityFileDataSetDescriptor(optionsPanel.isVoyager1() ? "1" : "2", source, plane);
                            }
                            r.setDataSetDescriptor(dsd);
                            r.setColor(getNextNonColorbarColor());
                            app.overlayRenderers.put(key, r);
                            app.overlayLabels.put(key, symLabel);
                            app.plot.addRenderer(r);
                            app.legend.add(r, key);
                            symLabel.setIcon(r.getListIcon());
                        } catch (IOException ex) {
                            DasExceptionHandler.handle(ex);
                            return;
                        } catch (PDSException ex ) {
                            DasExceptionHandler.handle(ex);
                            return;
                        } catch (DasException ex ) {
                            DasExceptionHandler.handle(ex);
                            return;
                        }
                    } else {
                        app.legend.add(r, key);
                    }
                    r.setActive(true);
                } else {
                    SeriesRenderer r = (SeriesRenderer) app.overlayRenderers.get(key);
                    if (r != null) {
                        r.setActive(false);
                        app.legend.remove(r);
                    }
                }
            }
        });

        return result;
    }

    void initComponents() {
        final Object[] sources = new Object[]{"",
            DensityFileDataSetDescriptor.P_SOURCE_TYPE,
            DensityFileDataSetDescriptor.L_SOURCE_TYPE,
            DensityFileDataSetDescriptor.U_SOURCE_TYPE,
            DensityFileDataSetDescriptor.R_SOURCE_TYPE,
            DensityFileDataSetDescriptor.INDEX_SOURCE_TYPE,
            //DensityFileDataSetDescriptor.PDS_SOURCE_TYPE,
            DensityFileDataSetDescriptor.PDS_HTTP_SOURCE_TYPE,
        };

        final Object[] frequencies = new Object[]{"",
            DensityFileDataSetDescriptor.FPE_PLANE_TYPE,
            DensityFileDataSetDescriptor.FL_PLANE_TYPE,
            DensityFileDataSetDescriptor.FR_PLANE_TYPE,
            DensityFileDataSetDescriptor.FUH_PLANE_TYPE,
            DensityFileDataSetDescriptor.FCE_PLANE_TYPE
        ,

           
         };
        
        overlaysPanel= new JPanel();
        overlaysPanel.setPreferredSize( new Dimension( 300, 300));
        overlaysPanel.setMaximumSize(new Dimension(300, 300));
        overlaysPanel.setLayout(new GridLayout(frequencies.length, sources.length));

        for (int j = 0; j < sources.length; j++) {
            overlaysPanel.add(new JLabel(String.valueOf(sources[j])));
        }
        for (int i = 1; i < frequencies.length; i++) {
            for (int j = 0; j < sources.length; j++) {
                if (j == 0) {
                    overlaysPanel.add(new JLabel(String.valueOf(frequencies[i])));
                } else {
                    overlaysPanel.add(getOverlaySelector((DensityFileDataSetDescriptor.SourceType) sources[j], (DensityFileDataSetDescriptor.PlaneType) frequencies[i]));
                }
            }
        }

    }

    protected void refresh() {
        for (Iterator i = app.overlayRenderers.keySet().iterator(); i.hasNext();) {
            Object key = i.next();
            JLabel label = (JLabel) app.overlayLabels.get(key);
            SeriesRenderer rend = (SeriesRenderer) app.overlayRenderers.get(key);
            label.setIcon(rend.getListIcon());
        }
    }
    PropertyChangeListener sclistener = new PropertyChangeListener() {

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(optionsPanel.PROP_VOYAGER1)) {
                updateDSDs();
            }
        }
    };

    DigitizerOverlaysSelector(VoyagerHighRate app, HROptionsPanel optionsPanel) {
        this.app = app;
        this.optionsPanel = optionsPanel;
        optionsPanel.addPropertyChangeListener(sclistener);
        initComponents();
    }

    private void updateDSDs() {
        Set keys= app.overlayRenderers.keySet();
        for ( Iterator i= keys.iterator(); i.hasNext();) {
            Object o=  i.next() ;
            SeriesRenderer r = (SeriesRenderer) app.overlayRenderers.get( o );
            DensityFileDataSetDescriptor dsd= (DensityFileDataSetDescriptor) r.getDataSetDescriptor();
            try {
            DensityFileDataSetDescriptor newdsd= 
                    new DensityFileDataSetDescriptor( optionsPanel.isVoyager1() ? "1" : "2", dsd.source, dsd.planeType );
            r.setDataSetDescriptor(newdsd);
            } catch ( FileSystemOfflineException ex ) {
                r.setException(ex);
            }
        }
    }
}
