/*
 * PDensityFileParser.java
 *
 * Created on March 9, 2006, 4:31 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

//import edu.uiowa.physics.pw.apps.vgpws.*;
import org.das2.dataset.DataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.TimeParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;

/**
 *
 * @author Jeremy
 */
public class DensityFileParser {
    AsciiColumnFileParser parser;
    DensityFileParser() {
        parser= new AsciiColumnFileParser();
        TimeParser timeParser= TimeParser.create( "%Y %j %H %M %S.%{milli}" );        
        parser.addTimeColumn( timeParser, 0, 22 );
        //fpe, f(L=0), f(R=0), and fuh
        parser.addColumn( "", 35, 48, Units.hertz );
        parser.addColumn( "fpe", 118, 131, Units.hertz );
        parser.setColumnFill("fpe",-1);
        parser.addColumn( "f(L=0)", 131, 144, Units.hertz );
        parser.setColumnFill("f(L=0)",-1);
        parser.addColumn( "f(R=0)", 144, 157, Units.hertz );
        parser.setColumnFill("f(R=0)",-1);
        parser.addColumn( "fuh", 157, 170, Units.hertz );
        parser.setColumnFill("fuh",-1);
        parser.addColumn( "fce", 22, 35, Units.hertz );
        parser.setColumnFill( "fce", -1 );
        parser.setProperty( DataSet.PROPERTY_X_TAG_WIDTH, Datum.create( 1, Units.seconds ) );
    }
    
    public DataSet parse( BufferedReader reader ) throws ParseException, IOException {
        return parser.parse(reader);
    }
}
