/* File: CrossHairMouseModule.java
 * Copyright (C) 2002-2003 The University of Iowa
 * Created by: Jeremy Faden <jbf@space.physics.uiowa.edu>
 *             Jessica Swanner <jessica@space.physics.uiowa.edu>
 *             Edward E. West <eew@space.physics.uiowa.edu>
 *
 * This file is part of the das2 library.
 *
 * das2 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.event.DataPointSelectionEvent;
import org.das2.event.MousePointSelectionEvent;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.CommentDataPointSelectionEvent;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.DataSetConsumer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import java.awt.event.*;
import org.das2.components.VerticalSpectrogramSlicer;

/**
 *
 * @author  Owner
 */
public class DDCrossHairMouseModule extends CrossHairMouseModule implements KeyListener {
    
    MousePointSelectionEvent lastMousePoint;
    DasPlot parent;
    VerticalSpectrogramSlicer slicer;
    
    public DDCrossHairMouseModule(DasPlot parent, DasAxis xaxis, DasAxis yaxis) {
        this( parent, parent, xaxis, yaxis );
    }
    
    public DDCrossHairMouseModule( DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis ) {
        super(parent,dataSetConsumer,xAxis,yAxis);
        parent.addKeyListener(this);
        this.parent= parent;
        if ( dataSetConsumer instanceof TableDataSetConsumer ) {
            slicer= VerticalSpectrogramSlicer.createSlicer(parent, (TableDataSetConsumer)dataSetConsumer );
        }
    }
    
    public static CrossHairMouseModule create( DasPlot parent ) {
        DasAxis xaxis= parent.getXAxis();
        DasAxis yaxis= parent.getYAxis();
        return new DDCrossHairMouseModule(parent,xaxis,yaxis);
    }
    
    public String getLabel() {
        return "KB Crosshair Digitizer";
    }
    
    public void mouseReleased(MouseEvent e) {
        lastMousePoint=null;
    }
    
    public void mousePointSelected(MousePointSelectionEvent e) {
        this.lastMousePoint= e;
        parent.requestFocus();
        if ( slicer!=null ) {
            slicer.dataPointSelected(super.getDataPointSelectionEvent(e));
        }
    }
    
    public void keyPressed(KeyEvent e) {
        int keyCode= e.getKeyCode();
        
        if ( lastMousePoint!=null ) {
            if ( keyCode==KeyEvent.VK_LEFT || keyCode==KeyEvent.VK_RIGHT || keyCode==KeyEvent.VK_UP || keyCode==KeyEvent.VK_DOWN ) {
                int x=0;
                int y=0;
                try {
                    int xOff= parent.getLocationOnScreen().x-parent.getX();
                    int yOff= parent.getLocationOnScreen().y-parent.getY();
                    final java.awt.Robot robot= new java.awt.Robot();
                    switch ( keyCode ) {
                        case KeyEvent.VK_LEFT:
                            robot.mouseMove(lastMousePoint.getX()+xOff-1, lastMousePoint.getY()+yOff);
                            break;
                        case KeyEvent.VK_RIGHT:
                            robot.mouseMove(lastMousePoint.getX()+xOff+1, lastMousePoint.getY()+yOff);
                            break;
                        case KeyEvent.VK_UP:
                            robot.mouseMove(lastMousePoint.getX()+xOff, lastMousePoint.getY()+yOff-1);
                            break;
                        case KeyEvent.VK_DOWN:
                            robot.mouseMove(lastMousePoint.getX()+xOff, lastMousePoint.getY()+yOff+1);
                            break;
                    }
                } catch ( java.awt.AWTException e1 ) {
                    org.das2.util.DasDie.println(e1.getMessage());
                }
                
            } else {
                
                DataPointSelectionEvent dpse= super.getDataPointSelectionEvent(lastMousePoint);                
                super.fireDataPointSelectionListenerDataPointSelected(
                CommentDataPointSelectionEvent.create( dpse, ""+e.getKeyChar() ) );
            }
        }
    }
    
    public void keyReleased(KeyEvent e) {
    }
    
    public void keyTyped(KeyEvent e) {
    }
    
}
