/*
 * CutoffMouseModuleDemo.java
 *
 * Created on October 18, 2005, 4:12 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;
// import edu.uiowa.physics.pw.apps.digitizerDemo.*; 
import org.das2.DasException;
import org.das2.components.DasTimeRangeSelector;
import org.das2.components.DataPointRecorder;
import org.das2.components.TearoffTabbedPane;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.CutoffMouseModule;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;




/**
 *
 * @author Jeremy
 */
public class CutoffDigitizerDemo {
    CutoffMouseModule testModule;
    DasCanvas canvas;
    DasPlot plot;
    SpectrogramRenderer renderer;
    DataPointRecorder recorder;
    TearoffTabbedPane tabpane;
    JFrame jframe;
    
    // Cassini WFR
    final static String DATASET= "http://www-pw.physics.uiowa.edu/das/das2Server?/das2_1/cassini/WFRew&1";
    final static DatumRange ZRANGE= new DatumRange( Datum.create(1e-14), Datum.create(1e-10) );
    final static DatumRange YRANGE= new DatumRange(  0, 5000, Units.hertz );
    final static DatumRange XRANGE= DatumRangeUtil.parseTimeRangeValid( "2006-12-02T15:00 to 21:00" );
    final static Datum XRESOLUTION= Units.milliseconds.createDatum( 33000 );
    final static Datum CUTOFF_LEVEL= Units.dimensionless.createDatum( -12 );
    final static Datum SLOPE_LEVEL= Units.dimensionless.createDatum( 0 );
    final static boolean LOWCUTOFF= false;
    
    // Voyager High Rate
    /*final static String DATASET= "http://www-pw.physics.uiowa.edu/das/das2Server?/voyager1/pws/wf-ps-fft1600";
    final static Datum XRESOLUTION= Units.milliseconds.createDatum(1000);
    final static DatumRange XRANGE= DatumRangeUtil.parseTimeRangeValid( "1979-3-1 20:05 to 20:05:30" );
    final static DatumRange XRANGE= DatumRange.newDatumRange( 0, 15, Units.kiloHertz );
    final static Datum XRESOLUTION= Units.milliseconds.createDatum( 1000 );
     */
    
    private void createComponents() throws DasException {
        canvas= new DasCanvas(640,480);
        DasRow row= DasRow.create(canvas);
        DasColumn col= DasColumn.create(canvas);
        
        // March 5, 1979   0932 - 0945 UT.
        
        //DasAxis yAxis= new DasAxis( DatumRange.newDatumRange( 0, 15, Units.kiloHertz ), DasAxis.VERTICAL );
        DasAxis xAxis= new DasAxis( XRANGE, DasAxis.HORIZONTAL );
        DasAxis yAxis= new DasAxis( YRANGE, DasAxis.VERTICAL );

        plot= new DasPlot(xAxis,yAxis);
        
        canvas.add(plot,row,col);
        DataSetDescriptor dsd= DataSetDescriptor.create(DATASET);
        
        DasColorBar colorBar= new DasColorBar( ZRANGE.min(), ZRANGE.max(), true );
        canvas.add( colorBar, plot.getRow(), DasColorBar.getColorBarColumn(plot.getColumn()) );
        renderer= new SpectrogramRenderer(dsd,colorBar);
        renderer.setSliceRebinnedData(false);
        renderer.setRebinner( SpectrogramRenderer.RebinnerEnum.nearestNeighbor );
        
        plot.addRenderer(renderer);
        
        final SymbolLineRenderer digitizedRenderer= new SymbolLineRenderer();
        final SymbolLineRenderer selectedRenderer= new SymbolLineRenderer();
        selectedRenderer.setPsymConnector(PsymConnector.NONE);
        selectedRenderer.setPsym(Psym.DOTS);
        selectedRenderer.setSymSize(8.0);
        selectedRenderer.setColor(Color.PINK);
        
        plot.addRenderer(selectedRenderer);
        
        digitizedRenderer.setColor( Color.white );
        plot.addRenderer(digitizedRenderer);
        
        CrossHairMouseModule mm= new DDCrossHairMouseModule(plot,renderer,plot.getXAxis(),plot.getYAxis());
        plot.getMouseAdapter().addMouseModule(mm);
        plot.getMouseAdapter().setPrimaryModule(mm);
        
        plot.getMouseAdapter().setSecondaryModule(plot.getMouseAdapter().getModuleByLabel("Zoom X"));
        
        tabpane= new TearoffTabbedPane();
        
        jframe= new JFrame("digitizer");
        
        Container contentPane;
        contentPane= jframe.getContentPane();
        
        JSplitPane pane= new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
        pane.add(canvas);
        
        JPanel crPane= new JPanel();
        crPane.setLayout(new BorderLayout());
        
        recorder= new DataPointRecorder();
        crPane.add(recorder,BorderLayout.CENTER);
        
        DasTimeRangeSelector tr= new DasTimeRangeSelector( xAxis.getDatumRange() );
        tr.addTimeRangeSelectionListener(xAxis);
        crPane.add(tr,BorderLayout.SOUTH);
        
        pane.add(crPane);
        
        tabpane.add("Plot",pane);
        
        contentPane.add(tabpane);
        
        mm.addDataPointSelectionListener(recorder);
        recorder.addDataSetUpdateListener( new DataSetUpdateListener() {
            public void dataSetUpdated( DataSetUpdateEvent e ) {
                digitizedRenderer.setDataSet( recorder.getDataSet() );
            }
        } );
        recorder.addSelectedDataSetUpdateListener( new DataSetUpdateListener() {
            public void dataSetUpdated( DataSetUpdateEvent e ) {
                selectedRenderer.setDataSet( recorder.getSelectedDataSet() );
            }
        } );
        
        jframe.setVisible(true);
        jframe.pack();
        jframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        
    }
    
    /** Creates a new instance of CutoffMouseModuleDemo */
    public CutoffDigitizerDemo() throws Exception {
        
        createComponents();
        
        DasPlot p= plot;
        
        IndexTool indt= new IndexTool(p,jframe);
        tabpane.add( "index", indt.getRecorder() );
        
        testModule= new CutoffMouseModule( p, renderer );
        testModule.setKeyEvents(true);
        testModule.setReleaseEvents(false);
        testModule.setXResolution( XRESOLUTION );
        testModule.setLowCutoff( LOWCUTOFF );
        testModule.setSlopeMin( SLOPE_LEVEL );
        testModule.setLevelMin( CUTOFF_LEVEL );
        
        p.addMouseModule( testModule );
        p.getMouseAdapter().setPrimaryModule( testModule );
        
        recorder.setXTagWidth( XRESOLUTION );
        
        testModule.addDataSetUpdateListener( recorder.getAppendDataSetUpListener() );
        
        VerticalSlicerMouseModule mm= new VerticalSlicerMouseModule(p,renderer, p.getXAxis(), p.getYAxis() );
        mm.setLabel("cutoff slice");
        
        DataPointSelectionListener slicer= testModule.getSlicer( p, renderer );
        mm.addDataPointSelectionListener( slicer );
        p.addMouseModule( mm );
        
        recorder.addDataPointSelectionListener(slicer);
        
        BoxSelectorMouseModule mm2= new BoxSelectorMouseModule(
                p,
                p.getXAxis(),
                p.getYAxis(),
                renderer,
                new BoxRenderer(p,true), "Recorder Select" );
        
        mm2.addBoxSelectionListener( new BoxSelectionListener() {
            public void BoxSelected( BoxSelectionEvent event ) {
                recorder.select( event.getXRange(), event.getYRange() );
            }
        } );
        
        p.addMouseModule( mm2 );
        p.getMouseAdapter().setSecondaryModule(mm2);
        
        plot.getXAxis().addToFavorites( DatumRangeUtil.parseTimeRangeValid("1979-3-1 20:05 to 20:06"));
        plot.getXAxis().addToFavorites( DatumRangeUtil.parseTimeRangeValid("1979-3-1 20:06 to 20:07"));
        
        
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {
        new CutoffDigitizerDemo();
    }
}
