/*
 * DensityFileParser.java
 *
 * Created on March 9, 2006, 4:09 PM
 *
 *
 */

package edu.uiowa.physics.pw.apps.vgpws_hr;

import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.TimeParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Jeremy
 */
public class AsciiColumnFileParser {
    private TimeParser timeParser;
    
    private List columnList;
    
    private int timeStartColumn;
    private int timeEndColumn;
    private int primaryColumn;
    private int columnCount;
    private Map properties;
    
    public AsciiColumnFileParser( ) {
        columnCount=0;
        columnList= new ArrayList();
        properties= new HashMap();
    }
    
    class Column {
        String planeId;
        Units units;
        double fill;
        int startColumn;
        int endColumn;
    }
    
    public void setProperty( String name, Object value ) {
        properties.put( name, value );
    }
    
    public void addTimeColumn( TimeParser timeParser, int startColumn, int endColumn ) {
        this.timeParser= timeParser;
        timeStartColumn= startColumn;
        timeEndColumn= endColumn;
    }
    
    public void addColumn( int startColumn, int endColumn, Units units ) {
        addColumn( "", startColumn, endColumn, units );
    }
    
    public void addColumn( String planeId, int startColumn, int endColumn, Units units ) {
        if (planeId.equals("")) primaryColumn= columnCount;
        
        Column column= new Column();
        column.planeId= planeId;
        column.startColumn= startColumn;
        column.endColumn= endColumn;
        column.units= units;
        column.fill= -1e31;
        
        columnList.add( column );
        
        columnCount++;
    }
    
    private int columnIndex( String planeId ) {
        for ( int i=0; i<columnCount; i++ ) {
            if ( ((Column)columnList.get(i)).planeId.equals(planeId) ) {
                return i;
            }
        }
        throw new IllegalArgumentException("plane not found");
    }
    
    public void setColumnFill( String planeId, double fillValue ) {
        int i= columnIndex(planeId);
        ((Column)columnList.get(i)).fill= fillValue;
    }
    
    public VectorDataSetBuilder createDataSetBuilder() {
        VectorDataSetBuilder builder= new VectorDataSetBuilder( Units.us2000, ((Column)columnList.get(primaryColumn)).units );
        for ( int i=0; i<columnCount; i++ ) {
            Column col= (Column)columnList.get(i);
            if ( i != primaryColumn ) builder.addPlane( col.planeId, col.units );
        }
        return builder;
    }
    
    /**
     * parses the line, putting the data into the builder.  The builder should be created with 
     * createDataSetBuilder so that the plane names are as expected.
     */
    public void parseLine( String line, VectorDataSetBuilder builder ) throws ParseException {
        timeParser.parse( line.substring( timeStartColumn, timeEndColumn ) );
        Datum x= timeParser.getTimeDatum();
        for ( int i=0; i<columnCount; i++ ) {
            Column col= (Column)columnList.get(i);
            Datum y= col.units.parse( line.substring( col.startColumn, col.endColumn ).trim() );
            builder.insertY( x, y, col.planeId );
        }    
    }
    
    /**
     * reads the buffer into a VectorDataSet.
     */
    public DataSet parse( BufferedReader reader ) throws IOException, ParseException {
        VectorDataSetBuilder builder= createDataSetBuilder();
        int lineNum=0;
        String line= reader.readLine();
        while ( line!=null ) {
            lineNum++;
            parseLine(line,builder);
            line= reader.readLine();
        }
        
        builder.addProperties( properties );
        
        return builder.toVectorDataSet();
    }
}
