# POSIX makefile for compiling and testing Voyager PWS waveform
# frame data lister
#
# Instructions:
#
# (1) Copy all files from the EXTRAS/SOFTWARE/C volume directory to
#     a writable directory.
#
# (2) Edit the entry for CC below for your platform if necessary.
#
# (3) make -f VGPWS_WF_LIST.MAK
#
# (4) make -f VGPWS_WF_LIST.MAK test

CC = gcc

CFLAGS = -O


vgpws_wf_list: vgpws_wf_list.c
	$(CC) $(CFLAGS) -o vgpws_wf_list vgpws_wf_list.c

# Make newline terminated source
vgpws_wf_list.c: VGPWS_WF_LIST.C
	tr -d \\r < VGPWS_WF_LIST.C > vgpws_wf_list.c


test: vgpws_wf_list verify.txt verify.diff
	@test ! -s verify.diff && echo "vgpws_wf_list is CORRECT" \
	|| echo "vgpws_wf_list verification FAILED!  See verify.diff."

verify.txt: vgpws_wf_list TESTIN.DAT
	./vgpws_wf_list < TESTIN.DAT > verify.txt

verify.diff: verify.txt TESTOUT.TXT
	-diff TESTOUT.TXT verify.txt > verify.diff


clean:
	rm vgpws_wf_list vgpws_wf_list.c
	rm verify.diff verify.txt
