/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.util.Random;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.dataset.test.BigVectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.GraphUtil;
import org.das2.graph.PsymConnector;
import org.das2.graph.SeriesRenderer;
import org.das2.util.monitor.NullProgressMonitor;

public class PlotSymbolRendererDemo {
    public static void doit() {
        VectorDataSet vds = BigVectorDataSet.getDataSet(100000, new NullProgressMonitor());
        DasPlot p = GraphUtil.visualize(vds);
        p.removeRenderer(p.getRenderer(0));
        SeriesRenderer r2 = new SeriesRenderer();
        r2.setPsym(DefaultPlotSymbol.CIRCLES);
        r2.setSymSize(10.0);
        r2.setPsymConnector(PsymConnector.NONE);
        p.addRenderer(r2);
        r2.setDataSet(vds);
        p.setPreviewEnabled(true);
        p.getXAxis().setAnimated(false);
        p.getYAxis().setAnimated(false);
    }

    public static void doit2() {
        int size = 20000;
        double dsize = size;
        System.err.println("enter getDataSet");
        long t0 = System.currentTimeMillis();
        Random random = new Random(0L);
        VectorDataSetBuilder vbd = new VectorDataSetBuilder(Units.dimensionless, Units.dimensionless);
        vbd.addPlane("color", Units.dimensionless);
        double y = 0.0;
        for (int i = 0; i < size; ++i) {
            y += random.nextDouble() - 0.5;
            if (i % 100 == 10) {
                vbd.insertY((double)i / dsize, Units.dimensionless.getFillDouble());
                vbd.insertY((double)i / dsize, 0.0, "color");
                continue;
            }
            vbd.insertY((double)i / dsize, y);
            vbd.insertY((double)i / dsize, (i - 10) / 100, "color");
        }
        vbd.setProperty("xMonotonic", Boolean.TRUE);
        VectorDataSet vds = vbd.toVectorDataSet();
        System.err.println("done getDataSet in " + (System.currentTimeMillis() - t0) + " ms");
        DasPlot p = GraphUtil.visualize(vds);
        p.getColumn().setEmMaximum(-10.0);
        p.removeRenderer(p.getRenderer(0));
        SeriesRenderer r2 = new SeriesRenderer();
        DasColorBar cb = new DasColorBar(Datum.create(0), Datum.create(100), false);
        p.getCanvas().add(cb, p.getRow(), DasColumn.create(null, p.getColumn(), "100%+2em", "100%+4em"));
        r2.setColorBar(cb);
        r2.setPsym(DefaultPlotSymbol.CIRCLES);
        r2.setSymSize(10.0);
        r2.setPsymConnector(PsymConnector.NONE);
        r2.setColorByDataSetId("color");
        p.addRenderer(r2);
        r2.setDataSet(vds);
        p.setPreviewEnabled(true);
        p.getXAxis().setAnimated(false);
        p.getYAxis().setAnimated(false);
    }

    public static void main(String[] args) {
        PlotSymbolRendererDemo.doit2();
    }
}

