/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.monitor;

import org.das2.util.monitor.ProgressMonitor;

public class SubTaskMonitor
implements ProgressMonitor {
    ProgressMonitor parent;
    long min;
    long max;
    long progress;
    long size;
    String label;
    private boolean finished = false;
    boolean started = false;

    private SubTaskMonitor(ProgressMonitor parent, long min, long max) {
        this.parent = parent;
        this.min = min;
        this.max = max;
        this.size = -1L;
    }

    public static SubTaskMonitor create(ProgressMonitor parent, long min, long max) {
        return new SubTaskMonitor(parent, min, max);
    }

    public void cancel() {
        this.parent.cancel();
    }

    public void finished() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getTaskProgress() {
        return this.progress;
    }

    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    @Deprecated
    public void setAdditionalInfo(String s) {
    }

    public void setTaskProgress(long position) throws IllegalArgumentException {
        this.progress = position;
        if (this.size == -1L) {
            this.parent.setTaskProgress(this.min);
        } else {
            this.parent.setTaskProgress(this.min + (this.max - this.min) * position / this.size);
        }
    }

    public void setTaskSize(long taskSize) {
        this.size = taskSize;
    }

    public long getTaskSize() {
        return this.size;
    }

    public void started() {
        this.started = true;
        if (!this.parent.isStarted()) {
            this.parent.started();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.parent.toString() + ">" + this.label;
    }

    public void setProgressMessage(String message) {
    }
}

