/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class LocalFileObject
extends FileObject {
    File localFile;
    File localRoot;
    LocalFileSystem lfs;

    protected LocalFileObject(LocalFileSystem lfs, File localRoot, String filename) {
        this.lfs = lfs;
        this.localFile = new File(localRoot, filename);
        this.localRoot = localRoot;
    }

    public boolean canRead() {
        return this.localFile.canRead();
    }

    public FileObject[] getChildren() {
        File[] files = this.localFile.listFiles();
        FileObject[] result = new LocalFileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(files[i]));
        }
        return result;
    }

    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException {
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        if (!this.localFile.equals(this.localRoot)) {
            return new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(this.localFile.getParentFile()));
        }
        return null;
    }

    public long getSize() {
        return this.localFile.length();
    }

    public boolean isData() {
        return this.localFile.isFile();
    }

    public boolean isFolder() {
        return this.localFile.isDirectory();
    }

    public boolean isReadOnly() {
        return !this.localFile.canWrite();
    }

    public boolean isRoot() {
        return this.localFile.getParentFile() == null;
    }

    public Date lastModified() {
        return new Date(this.localFile.lastModified());
    }

    public boolean exists() {
        return this.localFile.exists();
    }

    public String getNameExt() {
        return FileSystem.toCanonicalFilename(this.localFile.toString().substring(this.localRoot.toString().length()));
    }

    public String toString() {
        return "[" + this.lfs + "]" + this.getNameExt();
    }

    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream(monitor)).getChannel();
    }

    public File getFile() throws FileNotFoundException {
        return this.getFile(new NullProgressMonitor());
    }

    public File getFile(ProgressMonitor monitor) throws FileNotFoundException {
        if (!this.localFile.exists()) {
            throw new FileNotFoundException("file not found: " + this.localFile);
        }
        return this.localFile;
    }

    public boolean isLocal() {
        return true;
    }
}

