/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;

public class Glob {
    private static String getParentDirectory(String regex) {
        String dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = s[0];
            for (int i = 1; i < s.length - 1; ++i) {
                dirRegex = dirRegex + "/" + s[i];
            }
        } else {
            dirRegex = null;
        }
        String fileRegex = s[s.length - 1];
        return dirRegex;
    }

    private static boolean isRoot(String glob) {
        File root = new File(glob);
        return root.getParentFile() == null;
    }

    public static Pattern getPattern(String glob) {
        String regex = Glob.getRegex(glob);
        Pattern absPattern = Pattern.compile(regex);
        return absPattern;
    }

    public static String getRegex(String glob) {
        return glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
    }

    public static FileObject[] unGlob(FileSystem fs, String glob) throws IOException {
        return Glob.unGlob(fs, glob, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FileObject[] unGlob(FileSystem fs, String glob, boolean directoriesOnly) throws IOException {
        FileObject[] files;
        String parentGlob;
        if (File.separatorChar == '\\') {
            glob = glob.replaceAll("\\\\", "/");
        }
        if ((parentGlob = Glob.getParentDirectory(glob)) == null) throw new IllegalArgumentException("absolute files only");
        if (Glob.isRoot(parentGlob)) {
            FileObject rootFile = fs.getFileObject(parentGlob);
            if (!rootFile.exists()) throw new IllegalArgumentException("root does not exist: " + glob);
            files = new FileObject[]{rootFile};
        } else {
            files = Glob.unGlob(fs, parentGlob, true);
        }
        String regex = Glob.getRegex(glob);
        Pattern absPattern = Pattern.compile(regex);
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        for (int i = 0; i < files.length; ++i) {
            FileObject[] files1 = files[i].getChildren();
            for (int j = 0; j < files1.length; ++j) {
                FileObject file = files1[j];
                String s = file.getNameExt();
                if (!absPattern.matcher(s).matches() || directoriesOnly && !file.isFolder()) continue;
                list.add(file);
            }
        }
        return list.toArray(new FileObject[list.size()]);
    }

    public static FileFilter getGlobFileFilter(final String glob) {
        final Pattern pattern = Glob.getPattern(glob);
        return new FileFilter(){

            public boolean accept(File pathname) {
                return pattern.matcher(pathname.getName()).matches();
            }

            public String getDescription() {
                return glob;
            }
        };
    }
}

