/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class FileSystemUtil {
    public static void dumpToFile(InputStream in, File f) throws FileNotFoundException, IOException {
        ReadableByteChannel ic = Channels.newChannel(in);
        FileChannel oc = new FileOutputStream(f).getChannel();
        if (ic instanceof FileChannel) {
            FileChannel fic = (FileChannel)ic;
            fic.transferTo(0L, fic.size(), oc);
            fic.close();
            oc.close();
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(16384);
            while (ic.read(buf) >= 0 || buf.position() != 0) {
                buf.flip();
                oc.write(buf);
                buf.compact();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream("Hello there".getBytes());
        FileSystemUtil.dumpToFile(in, new File("/home/jbf/text.txt"));
    }
}

