/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.das2.DasApplication;

public class FileSystemSettings {
    protected File localCacheDir = null;
    public static final String PROP_LOCALCACHEDIR = "localCacheDir";
    protected Persistence persistence = Persistence.SESSION;
    public static final String PROP_PERSISTENCE = "persistence";
    protected boolean allowOffline = false;
    public static final String PROP_ALLOWOFFLINE = "allowOffline";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected FileSystemSettings() {
        File local;
        if (!DasApplication.hasAllPermission()) {
            local = new File("applet_mode");
        } else {
            local = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
            local = new File(local, ".das2/fsCache/wfs/");
        }
        this.localCacheDir = local;
    }

    public File getLocalCacheDir() {
        return this.localCacheDir;
    }

    public void setLocalCacheDir(File localCacheDir) {
        File oldLocalCacheDir = this.localCacheDir;
        this.localCacheDir = localCacheDir;
        this.propertyChangeSupport.firePropertyChange(PROP_LOCALCACHEDIR, oldLocalCacheDir, localCacheDir);
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Persistence persistence) {
        Persistence oldPersistence = this.persistence;
        this.persistence = persistence;
        this.propertyChangeSupport.firePropertyChange(PROP_PERSISTENCE, (Object)oldPersistence, (Object)persistence);
    }

    public boolean isAllowOffline() {
        return this.allowOffline;
    }

    public void setAllowOffline(boolean allowOffline) {
        boolean oldAllowOffline = allowOffline;
        this.allowOffline = allowOffline;
        this.propertyChangeSupport.firePropertyChange(PROP_ALLOWOFFLINE, oldAllowOffline, allowOffline);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Persistence {
        NONE,
        SESSION,
        EXPIRES,
        ALWAYS;

    }
}

