/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FtpFileSystemFactory;
import org.das2.util.filesystem.HttpFileSystemFactory;
import org.das2.util.filesystem.LocalFileSystemFactory;
import org.das2.util.filesystem.SubFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public abstract class FileSystem {
    URL root;
    protected static Logger logger = Logger.getLogger("das2.filesystem");
    private static FileSystemSettings settings = new FileSystemSettings();
    static HashMap registry = new HashMap();
    public static final String PROP_CASE_INSENSITIVE = "caseInsensitive";
    protected HashMap properties = new HashMap(5);

    public static FileSystem create(URL root) throws FileSystemOfflineException {
        return FileSystem.create(root, new NullProgressMonitor());
    }

    public static FileSystem create(URL root, ProgressMonitor mon) throws FileSystemOfflineException {
        logger.fine("create filesystem " + root);
        if (root.getPath().contains(".zip") && registry.containsKey("zip")) {
            try {
                String surl = root.toString();
                int i = surl.indexOf(".zip");
                String[] ss = FileSystem.splitUrl(surl.substring(0, i + 4));
                URL parent = new URL(ss[2]);
                String zipname = ss[3].substring(ss[2].length());
                String subdir = surl.substring(i + 4);
                FileSystem remote = FileSystem.create(parent);
                File localZipFile = remote.getFileObject(zipname).getFile(mon);
                FileSystemFactory factory = (FileSystemFactory)registry.get("zip");
                FileSystem zipfs = factory.createFileSystem(localZipFile.toURI().toURL());
                if (subdir.equals("") || subdir.equals("/")) {
                    return zipfs;
                }
                return new SubFileSystem(zipfs, subdir);
            }
            catch (IOException ex) {
                throw new FileSystemOfflineException(ex);
            }
        }
        FileSystemFactory factory = (FileSystemFactory)registry.get(root.getProtocol());
        if (factory == null) {
            throw new IllegalArgumentException("unsupported protocol: " + root);
        }
        return factory.createFileSystem(root);
    }

    public static FileSystemSettings settings() {
        return settings;
    }

    public static void registerFileSystemFactory(String proto, FileSystemFactory factory) {
        registry.put(proto, factory);
    }

    protected FileSystem(URL root) {
        if (!root.toString().endsWith("/")) {
            String s = root.toString();
            try {
                root = new URL(s + "/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.root = root;
    }

    public URL getRootURL() {
        return this.root;
    }

    private static String getRegexFromGlob(String glob) {
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return regex;
    }

    protected static String toCanonicalFilename(String filename) {
        if ((filename = filename.replaceAll("\\\\", "/")).length() == 0 || filename.charAt(0) != '/') {
            filename = "/" + filename;
        }
        filename = filename.replaceAll("//", "/");
        return filename;
    }

    protected static String toCanonicalFolderName(String name) {
        if (!(name = FileSystem.toCanonicalFilename(name)).endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    public abstract FileObject getFileObject(String var1);

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1, String var2) throws IOException;

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public abstract File getLocalRoot();

    public FileSystem createFileSystem(String directory) {
        try {
            return new SubFileSystem(this, FileSystem.toCanonicalFolderName(directory));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid directory: " + directory);
        }
    }

    public static String[] splitUrl(String surl) {
        int i3;
        int fileEnd;
        if (!(surl.startsWith("file:/") || surl.startsWith("ftp://") || surl.startsWith("http://") || surl.startsWith("https://"))) {
            surl = "file://" + (surl.charAt(0) == '/' ? surl : '/' + surl);
        }
        String params = null;
        int i = surl.indexOf("?");
        if (i != -1) {
            fileEnd = i;
            params = surl.substring(i + 1);
            if ((i = surl.indexOf("?", i + 1)) != -1) {
                throw new IllegalArgumentException("too many ??'s!");
            }
        } else {
            fileEnd = surl.length();
        }
        i = surl.lastIndexOf("/");
        String surlDir = surl.substring(0, i);
        String file = surl.substring(i, fileEnd);
        String ext = (i = file.lastIndexOf(46)) != -1 ? file.substring(i + 1) : "";
        int i2 = surl.indexOf("://") + 3;
        if (surl.indexOf("://") == -1 && surl.startsWith("file:/")) {
            i2 = 5;
        }
        if ((i3 = surl.indexOf("/", i2 + 1)) == -1) {
            i3 = i2;
        }
        String[] result = new String[]{surl.substring(0, i2), surl.substring(0, i3), surlDir + "/", surl.substring(0, fileEnd), ext, params};
        return result;
    }

    static {
        registry.put("file", new LocalFileSystemFactory());
        registry.put("http", new HttpFileSystemFactory());
        registry.put("https", new HttpFileSystemFactory());
        registry.put("ftp", new FtpFileSystemFactory());
    }

    public class DirectoryEntry {
        public String name;
        public char type;
        public long size;
        public long modified;
    }

    public static class FileSystemOfflineException
    extends IOException {
        public FileSystemOfflineException() {
        }

        public FileSystemOfflineException(String message) {
            super(message);
        }

        public FileSystemOfflineException(IOException e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }
}

