/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.fft;

public final class SimpleFFT {
    private static final double LOG_2 = Math.log(2.0);

    private SimpleFFT() {
    }

    public static double[][] fft(double[][] array) {
        double t_i;
        double t_r;
        int i;
        int n = array.length;
        int ln = (int)(Math.log(n) / LOG_2 + 0.5);
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[i - 1][0];
                t_i = array[i - 1][1];
                array[i - 1][0] = array[j - 1][0];
                array[i - 1][1] = array[j - 1][1];
                array[j - 1][0] = t_r;
                array[j - 1][1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * LOG_2) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = array[ip - 1][0] * u_r - u_i * array[ip - 1][1];
                    t_i = array[ip - 1][1] * u_r + u_i * array[ip - 1][0];
                    array[ip - 1][0] = array[i - 1][0] - t_r;
                    array[ip - 1][1] = array[i - 1][1] - t_i;
                    array[i - 1][0] = array[i - 1][0] + t_r;
                    array[i - 1][1] = array[i - 1][1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
        return array;
    }
}

