/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.das2.event.DasUpdateEvent;
import org.das2.system.DasLogger;

public final class EventQueueBlocker_1 {
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private static Object lockObject = new String("EQB_1");
    private static Runnable clearEventQueueImmediatelyRunnable = new Runnable(){

        public void run() {
            EventQueueBlocker_1.clearEventQueueImmediately();
        }
    };

    private EventQueueBlocker_1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEventQueueImmediately() {
        DasUpdateEvent evt = (DasUpdateEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(46288);
        if (evt != null) {
            logger.finer("pending update event: " + evt);
            EventQueue.invokeLater(clearEventQueueImmediatelyRunnable);
        } else {
            logger.finer("no update events found ");
            Object object = lockObject;
            synchronized (object) {
                lockObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEventQueue() throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must not be called on the EventQueue");
        }
        Object object = lockObject;
        synchronized (object) {
            if (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(46288) != null) {
                EventQueue.invokeLater(clearEventQueueImmediatelyRunnable);
                logger.finer("waiting for lockObject to indicate eventQueue is clear");
                lockObject.wait();
            } else {
                logger.finer("no update events found, no runnable submitted ");
            }
        }
    }

    public static void dumpEventQueue(PrintStream out) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        AWTEvent evt = null;
        Object result = null;
        while (eventQueue.peekEvent() != null) {
            try {
                evt = eventQueue.getNextEvent();
                out.println(evt);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            queue.add(evt);
        }
        while (queue.size() > 0) {
            eventQueue.postEvent((AWTEvent)queue.remove());
        }
    }
}

