/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;

public class TimeParser {
    static final Logger logger = Logger.getLogger("TimeParser");
    public static final String TIMEFORMAT_Z = "%Y-%m-%dT%H:%M:%S.%{milli}Z";
    TimeUtil.TimeStruct time;
    TimeUtil.TimeStruct timeWidth;
    int ndigits;
    String[] valid_formatCodes = new String[]{"Y", "y", "j", "m", "d", "H", "M", "S", "milli", "micro", "p", "z", "ignore", "b"};
    String[] formatName = new String[]{"Year", "2-digit-year", "day-of-year", "month", "day", "Hour", "Minute", "Second", "millisecond", "microsecond", "am/pm", "RFC-822 numeric time zone", "ignore", "3-char-month-name"};
    int[] formatCode_lengths = new int[]{4, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 5, -1, 3};
    int[] precision = new int[]{0, 0, 2, 1, 2, 3, 4, 5, 6, 7, -1, -1, -1, 1};
    int[] handlers;
    Map fieldHandlers;
    int[] offsets;
    int[] lengths;
    String[] delims;
    String[] fc;
    String regex;
    String formatString;
    int lsd;

    public static String iso8601String(String exampleTime) {
        int i = exampleTime.indexOf("T");
        if (i == -1) {
            i = exampleTime.indexOf(" ");
        }
        char dateTimeDelim = exampleTime.charAt(i);
        String date = null;
        String time = null;
        if (i != -1) {
            String datePart = exampleTime.substring(0, i);
            boolean hasDelim = !datePart.matches("\\d+");
            char delim = '\u0000';
            if (hasDelim) {
                delim = datePart.charAt(4);
            }
            switch (datePart.length()) {
                case 10: {
                    date = "%Y" + delim + "%m" + delim + "%d";
                    break;
                }
                case 9: {
                    date = "%Y" + delim + "%j";
                    break;
                }
                case 8: {
                    date = hasDelim ? "%Y" + delim + "%j" : "%Y%m%d";
                    break;
                }
                case 7: {
                    date = "%Y%j";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unable to identify date format for " + exampleTime);
                }
            }
            String timePart = exampleTime.substring(i + 1);
            if (timePart.endsWith("Z")) {
                timePart = timePart.substring(0, timePart.length() - 1);
            }
            hasDelim = !timePart.matches("\\d+");
            delim = '\u0000';
            if (hasDelim) {
                delim = timePart.charAt(2);
            }
            switch (timePart.length()) {
                case 4: {
                    time = "%H%M";
                    break;
                }
                case 5: {
                    time = "%H" + delim + "%M";
                    break;
                }
                case 6: {
                    time = "%H%M%S";
                    break;
                }
                case 8: {
                    time = "%H" + delim + "%M" + delim + "%S";
                    break;
                }
                case 12: {
                    time = "%H" + delim + "%M" + delim + "%S.%{milli}";
                    break;
                }
                case 15: {
                    time = "%H" + delim + "%M" + delim + "%S.%{milli}%{micro}";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unable to identify time format for " + exampleTime);
                }
            }
            if (timePart.endsWith("Z")) {
                time = time + "Z";
            }
            return date + dateTimeDelim + time;
        }
        throw new IllegalArgumentException("example time must contain T or space.");
    }

    private TimeParser(String formatString, Map fieldHandlers) {
        int pos;
        int i;
        this.time = new TimeUtil.TimeStruct();
        this.fieldHandlers = fieldHandlers;
        this.formatString = formatString;
        String[] ss = formatString.split("%");
        this.fc = new String[ss.length];
        String[] delim = new String[ss.length + 1];
        this.ndigits = ss.length;
        StringBuffer regex = new StringBuffer(100);
        regex.append(ss[0]);
        this.lengths = new int[this.ndigits];
        for (i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = -1;
        }
        delim[0] = ss[0];
        for (i = 1; i < this.ndigits; ++i) {
            int pp = 0;
            while (Character.isDigit(ss[i].charAt(pp)) || ss[i].charAt(pp) == '-') {
                ++pp;
            }
            this.lengths[i] = pp > 0 ? Integer.parseInt(ss[i].substring(0, pp)) : 0;
            if (ss[i].charAt(pp) != '{') {
                this.fc[i] = ss[i].substring(pp, pp + 1);
                delim[i] = ss[i].substring(pp + 1);
                continue;
            }
            int endIndex = ss[i].indexOf(125, pp);
            int comma = ss[i].indexOf(",", pp);
            this.fc[i] = comma != -1 ? ss[i].substring(pp + 1, comma) : ss[i].substring(pp + 1, endIndex);
            delim[i] = ss[i].substring(endIndex + 1);
        }
        this.handlers = new int[this.ndigits];
        this.offsets = new int[this.ndigits];
        this.offsets[0] = pos = 0;
        this.lsd = -1;
        for (int i2 = 1; i2 < this.ndigits; ++i2) {
            if (pos != -1) {
                pos += delim[i2 - 1].length();
            }
            int handler = 9999;
            for (int j = 0; j < this.valid_formatCodes.length; ++j) {
                if (!this.valid_formatCodes[j].equals(this.fc[i2])) continue;
                handler = j;
                break;
            }
            if (handler == 9999) {
                if (fieldHandlers == null || !fieldHandlers.containsKey(this.fc[i2])) {
                    throw new IllegalArgumentException("bad format code: \"" + this.fc[i2] + "\"");
                }
                this.lsd = 100;
                handler = 100;
                this.handlers[i2] = 100;
                this.offsets[i2] = pos;
                if (this.lengths[i2] < 1 || pos == -1) {
                    pos = -1;
                    this.lengths[i2] = -1;
                } else {
                    pos += this.lengths[i2];
                }
            } else {
                this.handlers[i2] = handler;
                if (this.lengths[i2] == 0) {
                    this.lengths[i2] = this.formatCode_lengths[handler];
                }
                this.offsets[i2] = pos;
                if (this.lengths[i2] < 1 || pos == -1) {
                    pos = -1;
                    this.lengths[i2] = -1;
                } else {
                    pos += this.lengths[i2];
                }
            }
            if (handler < 100 && this.precision[handler] > this.lsd) {
                this.lsd = this.precision[handler];
            }
            String dots = ".........";
            if (this.lengths[i2] == -1) {
                regex.append("(.*)");
            } else {
                regex.append("(" + dots.substring(0, this.lengths[i2]) + ")");
            }
            regex.append(delim[i2]);
        }
        this.timeWidth = new TimeUtil.TimeStruct();
        switch (this.lsd) {
            case 0: {
                this.timeWidth.year = 1;
                break;
            }
            case 1: {
                this.timeWidth.month = 1;
                break;
            }
            case 2: {
                this.timeWidth.day = 1;
                break;
            }
            case 3: {
                this.timeWidth.hour = 1;
                break;
            }
            case 4: {
                this.timeWidth.minute = 1;
                break;
            }
            case 5: {
                this.timeWidth.seconds = 1.0;
                break;
            }
            case 6: {
                this.timeWidth.millis = 1;
                break;
            }
            case 7: {
                this.timeWidth.micros = 1;
                break;
            }
        }
        this.delims = delim;
        this.regex = regex.toString();
    }

    public static TimeParser create(String formatString) {
        return new TimeParser(formatString, null);
    }

    public static TimeParser create(String formatString, String fieldName, FieldHandler handler) {
        HashMap<String, FieldHandler> map = new HashMap<String, FieldHandler>();
        map.put(fieldName, handler);
        return new TimeParser(formatString, map);
    }

    private double toUs2000(TimeUtil.TimeStruct d) {
        int year = d.year;
        int month = d.month;
        int day = d.day;
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = d.hour;
        int minute = d.minute;
        double seconds = d.seconds + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
        int mjd1958 = jd - 2436205;
        double us2000 = (double)(mjd1958 - 15340) * 8.64E10 + seconds * 1000000.0 + (double)(d.millis * 1000) + (double)d.micros;
        return us2000;
    }

    private double toUs1980(TimeUtil.TimeStruct d) {
        int year = d.year;
        int month = d.month;
        int day = d.day;
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = d.hour;
        int minute = d.minute;
        double seconds = d.seconds + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
        double us1980 = (double)(jd - 2436205 - 8035) * 8.64E10 + seconds * 1000000.0 + (double)d.millis * 1000.0 + (double)d.micros;
        return us1980;
    }

    public void resetSeconds() {
        this.time.seconds = 0.0;
    }

    public void sloppyColumns() {
        this.lengths[0] = -1;
        for (int i = 1; i < this.offsets.length; ++i) {
            this.offsets[i] = -1;
            this.lengths[i] = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeParser parse(String timeString) throws ParseException {
        int offs = 0;
        int len = 0;
        this.time.month = 1;
        this.time.day = 1;
        this.time.hour = 0;
        this.time.minute = 0;
        this.time.seconds = 0.0;
        this.time.micros = 0;
        for (int idigit = 1; idigit < this.ndigits; ++idigit) {
            offs = this.offsets[idigit] != -1 ? this.offsets[idigit] : (offs += len + this.delims[idigit - 1].length());
            if (this.lengths[idigit] != -1) {
                len = this.lengths[idigit];
            } else if (this.delims[idigit].equals("")) {
                if (idigit != this.ndigits - 1) throw new IllegalArgumentException("No delimer specified after unknown length field, \"" + this.formatName[this.handlers[idigit]] + "\", field number=" + (1 + idigit) + "");
                len = timeString.length() - offs;
            } else {
                int i = timeString.indexOf(this.delims[idigit], offs);
                if (i == -1) {
                    throw new ParseException("expected delimiter \"" + this.delims[idigit] + "\"", offs);
                }
                len = i - offs;
            }
            if (this.handlers[idigit] < 10) {
                int digit = Integer.parseInt(timeString.substring(offs, offs + len).trim());
                switch (this.handlers[idigit]) {
                    case 0: {
                        this.time.year = digit;
                        break;
                    }
                    case 1: {
                        this.time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                        break;
                    }
                    case 2: {
                        this.time.month = 1;
                        this.time.day = digit;
                        break;
                    }
                    case 3: {
                        this.time.month = digit;
                        break;
                    }
                    case 4: {
                        this.time.day = digit;
                        break;
                    }
                    case 5: {
                        this.time.hour = digit;
                        break;
                    }
                    case 6: {
                        this.time.minute = digit;
                        break;
                    }
                    case 7: {
                        this.time.seconds = digit;
                        break;
                    }
                    case 8: {
                        this.time.millis = digit;
                        break;
                    }
                    case 9: {
                        this.time.micros = digit;
                    }
                }
                continue;
            }
            if (this.handlers[idigit] == 100) {
                FieldHandler handler = (FieldHandler)this.fieldHandlers.get(this.fc[idigit]);
                handler.handleValue(timeString.substring(offs, offs + len), this.time, this.timeWidth);
                continue;
            }
            if (this.handlers[idigit] == 10) {
                char ch = timeString.charAt(offs);
                if (ch != 'P' && ch != 'p') continue;
                this.time.hour += 12;
                continue;
            }
            if (this.handlers[idigit] == 11) {
                int offset = Integer.parseInt(timeString.substring(offs, offs + len));
                this.time.hour -= offset / 100;
                this.time.minute -= offset % 100;
                continue;
            }
            if (this.handlers[idigit] != 13) continue;
            this.time.month = TimeUtil.monthNumber(timeString.substring(offs, offs + len));
        }
        return this;
    }

    public void setDigit(String format, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("value must not be negative");
        }
        String[] ss = format.split("%", -2);
        if (ss.length > 2) {
            throw new IllegalArgumentException("multiple fields not supported");
        }
        block11: for (int i = ss.length - 1; i > 0; --i) {
            int digit = (int)value;
            double fp = value - (double)digit;
            switch (ss[i].charAt(0)) {
                case 'Y': {
                    this.time.year = digit;
                    if (TimeUtil.isLeapYear(this.time.year)) {
                        this.time.seconds += 3.16224E7 * fp;
                        continue block11;
                    }
                    this.time.seconds += 3.1536E7 * fp;
                    continue block11;
                }
                case 'y': {
                    int n = this.time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                    if (TimeUtil.isLeapYear(this.time.year)) {
                        this.time.seconds += 3.16224E7 * fp;
                        continue block11;
                    }
                    this.time.seconds += 3.1536E7 * fp;
                    continue block11;
                }
                case 'j': {
                    this.time.month = 1;
                    this.time.day = digit;
                    this.time.seconds += 86400.0 * fp;
                    continue block11;
                }
                case 'm': {
                    this.time.month = digit;
                    this.time.seconds += (double)(TimeUtil.daysInMonth(this.time.month, this.time.year) * 24 * 3600) * fp;
                    continue block11;
                }
                case 'd': {
                    this.time.day = digit;
                    this.time.seconds += 86400.0 * fp;
                    continue block11;
                }
                case 'H': {
                    this.time.hour = digit;
                    this.time.seconds += 3600.0 * fp;
                    continue block11;
                }
                case 'M': {
                    this.time.minute = digit;
                    this.time.seconds += 60.0 * fp;
                    continue block11;
                }
                case 'S': {
                    this.time.seconds = (double)digit + fp;
                    continue block11;
                }
                case '{': {
                    if (ss[i].substring(1).equals("milli}")) {
                        this.time.millis = digit;
                        this.time.micros = (int)((double)this.time.micros + 1000.0 * fp);
                        this.time.seconds += (1000.0 * fp - (double)this.time.micros) * 1.0E-6;
                        continue block11;
                    }
                    if (!ss[i].substring(1).equals("micro}")) continue block11;
                    this.time.micros = digit;
                    this.time.seconds += fp * 1.0E-6;
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("format code not supported");
                }
            }
        }
    }

    public TimeParser setDigit(String format, int value) {
        String[] ss = format.split("%", -2);
        for (int i = ss.length - 1; i > 0; --i) {
            int mod = 0;
            switch (ss[i].charAt(0)) {
                case 'Y': {
                    int digit;
                    mod = 10000;
                    this.time.year = digit = value % mod;
                    break;
                }
                case 'y': {
                    mod = 100;
                    int digit = value % mod;
                    this.time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                    break;
                }
                case 'j': {
                    mod = 1000;
                    int digit = value % mod;
                    this.time.month = 1;
                    this.time.day = digit;
                    break;
                }
                case 'm': {
                    int digit;
                    mod = 100;
                    this.time.month = digit = value % mod;
                    break;
                }
                case 'd': {
                    int digit;
                    mod = 100;
                    this.time.day = digit = value % mod;
                    break;
                }
                case 'H': {
                    int digit;
                    mod = 100;
                    this.time.hour = digit = value % mod;
                    break;
                }
                case 'M': {
                    int digit;
                    mod = 100;
                    this.time.minute = digit = value % mod;
                    break;
                }
                case 'S': {
                    mod = 100;
                    int digit = value % mod;
                    this.time.seconds = digit;
                    break;
                }
                case '{': {
                    mod = 1000;
                    int digit = value % mod;
                    if (ss[i].substring(1).equals("milli}")) {
                        this.time.millis = digit;
                        break;
                    }
                    this.time.micros = digit;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("format code not supported");
                }
            }
            value /= mod;
        }
        return this;
    }

    public TimeParser setDigit(int digitNumber, int digit) {
        switch (this.handlers[digitNumber + 1]) {
            case 0: {
                this.time.year = digit;
                break;
            }
            case 1: {
                this.time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                break;
            }
            case 2: {
                this.time.month = 1;
                this.time.day = digit;
                break;
            }
            case 3: {
                this.time.month = digit;
                break;
            }
            case 13: {
                this.time.month = digit;
                break;
            }
            case 4: {
                this.time.day = digit;
                break;
            }
            case 5: {
                this.time.hour = digit;
                break;
            }
            case 6: {
                this.time.minute = digit;
                break;
            }
            case 7: {
                this.time.seconds = digit;
                break;
            }
            case 8: {
                this.time.millis = digit;
                break;
            }
            case 9: {
                this.time.micros = digit;
            }
        }
        return this;
    }

    public double getTime(Units units) {
        return Units.us2000.convertDoubleTo(units, this.toUs2000(this.time));
    }

    public Datum getTimeDatum() {
        if (this.time.year < 1990) {
            return Units.us1980.createDatum(this.toUs1980(this.time));
        }
        return Units.us2000.createDatum(this.toUs2000(this.time));
    }

    public DatumRange getTimeRange() {
        TimeUtil.TimeStruct time2 = this.time.add(this.timeWidth);
        double t1 = this.toUs2000(this.time);
        double t2 = this.toUs2000(time2);
        return new DatumRange(t1, t2, Units.us2000);
    }

    public double getEndTime(Units units) {
        throw new IllegalArgumentException("not implemented for DatumRanges as of yet");
    }

    public String getRegex() {
        return this.regex;
    }

    public String format(Datum start, Datum end) {
        StringBuffer result = new StringBuffer(100);
        int offs = 0;
        int len = 0;
        TimeUtil.TimeStruct timel = TimeUtil.toTimeStruct(start);
        NumberFormat[] nf = new NumberFormat[5];
        nf[2] = new DecimalFormat("00");
        nf[3] = new DecimalFormat("000");
        nf[4] = new DecimalFormat("0000");
        for (int idigit = 1; idigit < this.ndigits; ++idigit) {
            result.insert(offs, this.delims[idigit - 1]);
            offs = this.offsets[idigit] != -1 ? this.offsets[idigit] : (offs += this.delims[idigit - 1].length());
            len = this.lengths[idigit] != -1 ? this.lengths[idigit] : -9999;
            if (this.handlers[idigit] < 10) {
                int digit;
                switch (this.handlers[idigit]) {
                    case 0: {
                        digit = timel.year;
                        break;
                    }
                    case 1: {
                        digit = timel.year < 2000 ? timel.year - 1900 : timel.year - 2000;
                        break;
                    }
                    case 2: {
                        digit = TimeUtil.dayOfYear(timel.month, timel.day, timel.year);
                        break;
                    }
                    case 3: {
                        digit = timel.month;
                        break;
                    }
                    case 4: {
                        digit = timel.day;
                        break;
                    }
                    case 5: {
                        digit = timel.hour;
                        break;
                    }
                    case 6: {
                        digit = timel.minute;
                        break;
                    }
                    case 7: {
                        digit = (int)timel.seconds;
                        break;
                    }
                    case 8: {
                        digit = (int)Math.round(1000.0 * (timel.seconds - (double)((int)timel.seconds)));
                        digit += timel.millis;
                        break;
                    }
                    case 9: {
                        digit = timel.micros;
                        break;
                    }
                    default: {
                        throw new RuntimeException("shouldn't get here");
                    }
                }
                result.insert(offs, nf[len].format(digit));
                offs += len;
                continue;
            }
            if (this.handlers[idigit] == 13) {
                result.insert(offs, TimeUtil.monthNameAbbrev(timel.month));
                offs += len;
                continue;
            }
            if (this.handlers[idigit] == 100) {
                throw new RuntimeException("Handlers not supported");
            }
            if (this.handlers[idigit] == 10) {
                throw new RuntimeException("AM/PM supported");
            }
            if (this.handlers[idigit] != 11) continue;
            throw new RuntimeException("Time Zones not supported");
        }
        return result.toString().trim();
    }

    public static interface FieldHandler {
        public void handleValue(String var1, TimeUtil.TimeStruct var2, TimeUtil.TimeStruct var3);
    }
}

