/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.PropertyType;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.util.ByteBufferInputStream;
import org.das2.util.InflaterChannel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StreamTool {
    private static HashMap typesMap = new HashMap();

    public static byte[] advanceTo(InputStream in, byte[] delim) throws IOException, DelimeterNotFoundException {
        byte[] data = new byte[4096];
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int bytesMatched = 0;
        boolean matchIndex = false;
        boolean streamIndex = false;
        int index = 0;
        boolean notDone = true;
        int unreadOffset = -99999;
        int unreadLength = -99999;
        int totalBytesRead = 0;
        int offset = 0;
        while (notDone) {
            int byteRead = in.read();
            ++totalBytesRead;
            if (byteRead == -1) {
                notDone = false;
            } else {
                data[offset] = (byte)byteRead;
                bytesMatched = delim[bytesMatched] == byteRead ? ++bytesMatched : 0;
                if (bytesMatched == delim.length) {
                    notDone = false;
                    index = totalBytesRead - delim.length;
                }
            }
            if (!notDone || ++offset != 4096) continue;
            list.add(data);
            offset = 0;
            data = new byte[4096];
        }
        if (bytesMatched != delim.length) {
            throw new DelimeterNotFoundException();
        }
        byte[] result = new byte[index];
        for (int i = 0; i < list.size(); ++i) {
            System.arraycopy(list.get(i), 0, result, i * 4096, 4096);
        }
        System.arraycopy(data, 0, result, list.size() * 4096, index - list.size() * 4096);
        return result;
    }

    public static byte[] readXML(PushbackInputStream in) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(in);
        byte[] back = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(back);
        channel.read(buffer);
        buffer.flip();
        ByteBuffer xml = StreamTool.readXML(buffer);
        byte[] bytes = new byte[xml.remaining()];
        xml.get(bytes);
        return bytes;
    }

    private static void eatWhiteSpace(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            char c = (char)(0xFF & buffer.get());
            if (Character.isWhitespace(c)) continue;
            buffer.position(buffer.position() - 1);
            return;
        }
    }

    public static ByteBuffer readXML(ByteBuffer input) throws IOException {
        int gtCount = 0;
        int tagCount = 0;
        boolean bufidx = false;
        boolean inQuotes = false;
        boolean inTag = false;
        boolean tagContainsSlash = false;
        ByteBuffer buffer = input.duplicate();
        buffer.mark();
        StreamTool.eatWhiteSpace(buffer);
        int b = 0xFF & buffer.get();
        if ((char)b != '<') {
            throw new IOException("found '" + (char)b + "', expected '<' at offset=" + buffer.position() + ".\n");
        }
        ++gtCount;
        tagContainsSlash = false;
        while (buffer.hasRemaining() && (gtCount > 0 || tagCount > 0)) {
            char lastChar = (char)b;
            b = 0xFF & buffer.get();
            if (inQuotes && (char)b == '\"' && lastChar != '\\') {
                inQuotes = false;
                continue;
            }
            if ((char)b == '<') {
                ++gtCount;
                inTag = true;
                tagContainsSlash = false;
                continue;
            }
            if (b == 62) {
                --gtCount;
                inTag = false;
                if (lastChar == '/') continue;
                if (tagContainsSlash) {
                    --tagCount;
                    continue;
                }
                ++tagCount;
                continue;
            }
            if (b == 47) {
                if (lastChar != '<') continue;
                tagContainsSlash = true;
                continue;
            }
            if ((char)b != '\"' || !inTag) continue;
            inQuotes = true;
        }
        if (b == -1) {
            throw new IOException("unexpected end of file before xml termination\n");
        }
        StreamTool.eatWhiteSpace(buffer);
        int limit = buffer.limit();
        buffer.limit(buffer.position());
        buffer.reset();
        ByteBuffer result = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(limit);
        return result;
    }

    public static void readStream(ReadableByteChannel stream, StreamHandler handler) throws StreamException {
        ReadStreamStructure struct = new ReadStreamStructure(stream, handler);
        try {
            int bytesRead;
            StreamDescriptor sd = StreamTool.getStreamDescriptor(struct);
            if ("deflate".equals(sd.getCompression())) {
                stream = StreamTool.getInflaterChannel(stream);
            }
            handler.streamDescriptor(sd);
            struct.descriptorCount++;
            int totalBytesRead = 0;
            while ((bytesRead = stream.read(struct.bigBuffer)) != -1) {
                struct.byteOffset += struct.bigBuffer.position();
                struct.bigBuffer.flip();
                totalBytesRead += bytesRead;
                while (StreamTool.getChunk(struct)) {
                }
                struct.bigBuffer.compact();
            }
            handler.streamClosed(sd);
        }
        catch (StreamException se) {
            handler.streamException(se);
            throw se;
        }
        catch (IOException ioe) {
            StreamException se = new StreamException(ioe);
            handler.streamException(se);
            throw se;
        }
    }

    private static StreamDescriptor getStreamDescriptor(ReadStreamStructure struct) throws StreamException, IOException {
        struct.bigBuffer.clear().limit(10);
        while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
        }
        if (struct.bigBuffer.hasRemaining()) {
            throw new StreamException("Reached end of stream before encountering stream descriptor");
        }
        struct.byteOffset += struct.bigBuffer.position();
        struct.bigBuffer.flip();
        struct.bigBuffer.get(struct.four);
        if (StreamTool.isStreamDescriptorHeader(struct.four)) {
            int contentLength = StreamTool.getContentLength(struct.bigBuffer);
            if (contentLength == 0) {
                throw new StreamException("streamDescriptor content length is 0.");
            }
            struct.byteOffset += struct.bigBuffer.position();
            struct.bigBuffer.clear().limit(contentLength);
            while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
            }
            if (struct.bigBuffer.hasRemaining()) {
                throw new StreamException("Reached end of stream before encountering stream descriptor");
            }
            struct.byteOffset += struct.bigBuffer.position();
            struct.bigBuffer.flip();
            try {
                Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
                Element root = doc.getDocumentElement();
                if (root.getTagName().equals("stream")) {
                    StreamDescriptor sd = new StreamDescriptor(doc.getDocumentElement());
                    struct.bigBuffer.clear();
                    return sd;
                }
                if (root.getTagName().equals("exception")) {
                    throw StreamTool.exception(root);
                }
                throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
            }
            catch (SAXException ex) {
                String msg = StreamTool.getSAXParseExceptionMessage(ex, struct, contentLength);
                throw new StreamException(msg);
            }
        }
        String s = StreamTool.readMore(struct);
        throw new StreamException("Expecting stream descriptor header, found: '" + StreamTool.asciiBytesToString(struct.four, 0, 4) + "' beginning \n'" + s + "'");
    }

    private static String readMore(ReadStreamStructure struct) throws IOException {
        struct.bigBuffer.position(0);
        struct.bigBuffer.limit(10);
        byte[] bytes10 = new byte[10];
        struct.bigBuffer.get(bytes10);
        String s = new String(bytes10);
        struct.bigBuffer.limit(1000);
        struct.bigBuffer.position(0);
        while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
        }
        int p = struct.bigBuffer.position();
        byte[] bytes = new byte[p];
        struct.bigBuffer.flip();
        struct.bigBuffer.get(bytes);
        s = s + new String(bytes);
        return s;
    }

    private static String getSAXParseExceptionMessage(SAXException ex, ReadStreamStructure struct, int contentLength) {
        String loc = null;
        if (ex instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)ex;
            loc = "Relative to packet start, line number is " + spe.getLineNumber() + ", column is " + spe.getColumnNumber();
        }
        int bufOffset = struct.byteOffset - struct.bigBuffer.limit();
        String msg = "xml parser fails with the message: \"" + ex.getMessage() + "\" within the packet ending at byte offset " + (bufOffset + struct.bigBuffer.position()) + ".";
        if (ex.getMessage().contains("trailing")) {
            int bpos;
            int i;
            msg = msg + "\nNon-whitespace data found after xml closing tag, probably caused by content length error.";
            for (i = bufOffset + struct.bigBuffer.position() - 1; i > 0; --i) {
                bpos = i - bufOffset;
                if (struct.bigBuffer.get(bpos) == 62) break;
                System.err.println((char)struct.bigBuffer.get(bpos));
            }
            while (i < bufOffset + struct.bigBuffer.position()) {
                bpos = i - bufOffset;
                if (struct.bigBuffer.get(bpos) == 91 || struct.bigBuffer.get(bpos) == 58) break;
                ++i;
            }
            if (i > 0) {
                int error = i - (struct.bigBuffer.position() + bufOffset);
                DecimalFormat nf = new DecimalFormat("000000");
                msg = msg + "\nContent length was " + nf.format(contentLength) + ", maybe it should have been " + nf.format(contentLength + error) + ".";
            }
        }
        if (loc != null) {
            msg = msg + "  " + loc;
        }
        return msg;
    }

    private static final StreamException exception(Element exception) {
        String type = exception.getAttribute("type");
        return new StreamException(type);
    }

    private static boolean getChunk(ReadStreamStructure struct) throws StreamException, IOException {
        struct.bigBuffer.mark();
        if (struct.bigBuffer.remaining() < 4) {
            return false;
        }
        struct.bigBuffer.get(struct.four);
        if (StreamTool.isPacketDescriptorHeader(struct.four)) {
            if (struct.bigBuffer.remaining() < 6) {
                struct.bigBuffer.reset();
                return false;
            }
            int contentLength = StreamTool.getContentLength(struct.bigBuffer);
            if (contentLength == 0) {
                throw new StreamException("packetDescriptor content length is 0.");
            }
            if (struct.bigBuffer.capacity() < contentLength) {
                struct.bigBuffer.reset();
                ByteBuffer temp = ByteBuffer.allocate(8 + contentLength + contentLength / 10);
                temp.put(struct.bigBuffer);
                temp.flip();
                struct.bigBuffer = temp;
                return false;
            }
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            try {
                Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
                Element root = doc.getDocumentElement();
                if (root.getTagName().equals("packet")) {
                    PacketDescriptor pd = new PacketDescriptor(doc.getDocumentElement());
                    struct.handler.packetDescriptor(pd);
                    struct.descriptors.put(StreamTool.asciiBytesToString(struct.four, 1, 2), pd);
                } else {
                    if (root.getTagName().equals("exception")) {
                        throw StreamTool.exception(root);
                    }
                    if (root.getTagName().equals("comment")) {
                        struct.handler.streamComment(new StreamComment(doc.getDocumentElement()));
                    } else {
                        throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
                    }
                }
                struct.descriptorCount++;
            }
            catch (SAXException ex) {
                String msg = StreamTool.getSAXParseExceptionMessage(ex, struct, contentLength);
                throw new StreamException(msg);
            }
        } else if (StreamTool.isPacketHeader(struct.four)) {
            String key = StreamTool.asciiBytesToString(struct.four, 1, 2);
            PacketDescriptor pd = (PacketDescriptor)struct.descriptors.get(key);
            int contentLength = pd.getSizeBytes();
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            int yCount = pd.getYCount();
            Datum xTag = pd.getXDescriptor().readDatum(struct.bigBuffer);
            DatumVector[] vectors = new DatumVector[yCount];
            for (int i = 0; i < yCount; ++i) {
                vectors[i] = pd.getYDescriptor(i).read(struct.bigBuffer);
            }
            struct.handler.packet(pd, xTag, vectors);
            struct.packetCount++;
        } else {
            String msg = "Expected four byte header, found '";
            String s = new String(struct.four);
            s = s.replaceAll("\n", "\\\\n");
            msg = msg + s;
            msg = msg + "' at byteOffset=" + (struct.byteOffset + struct.bigBuffer.position() - 4);
            msg = msg + " after reading " + struct.descriptorCount + " descriptors and " + struct.packetCount + " packets.";
            throw new StreamException(msg);
        }
        return true;
    }

    private static ByteBuffer sliceBuffer(ByteBuffer buffer, int length) {
        ByteBuffer dup = buffer.duplicate();
        dup.limit(dup.position() + length);
        return dup.slice();
    }

    private static String asciiBytesToString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private static boolean isStreamDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[1] == 48 && four[2] == 48 && four[3] == 93;
    }

    private static boolean isPacketDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[3] == 93 && (Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]) || (char)four[1] == 'x' && (char)four[2] == 'x');
    }

    private static boolean isPacketHeader(byte[] four) {
        return four[0] == 58 && four[3] == 58 && Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]);
    }

    private static Document getXMLDocument(ByteBuffer buffer, int contentLength) throws StreamException, IOException, SAXException {
        ByteBuffer xml = buffer.duplicate();
        xml.limit(xml.position() + contentLength);
        buffer.position(buffer.position() + contentLength);
        boolean DEBUG = false;
        ByteBufferInputStream bbin = new ByteBufferInputStream(xml);
        InputStreamReader isr = new InputStreamReader(bbin);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(isr);
            Document document = builder.parse(source);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int getContentLength(ByteBuffer buffer) throws StreamException {
        int contentLength = 0;
        for (int i = 0; i < 6; ++i) {
            char c = (char)(0xFF & buffer.get());
            if (c == ' ') continue;
            if (!Character.isDigit(c)) {
                throw new StreamException("Invalid character in contentLength: '" + c + "'");
            }
            int digit = Character.digit(c, 10);
            contentLength = contentLength * 10 + digit;
        }
        return contentLength;
    }

    public static void formatHeader(Document document, Writer writer) throws StreamException {
        DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSOutput output = ls.createLSOutput();
        output.setCharacterStream(writer);
        LSSerializer serializer = ls.createLSSerializer();
        try {
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
        serializer.write(document, output);
    }

    public static Map processPropertiesElement(Element element) throws StreamException {
        try {
            if (!element.getTagName().equals("properties")) {
                throw new StreamException("expecting 'properties' element, encountered '" + element.getTagName() + "'");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String[] split = name.split(":");
                if (split.length == 1) {
                    map.put(name, attr.getValue());
                    continue;
                }
                if (split.length == 2) {
                    PropertyType type = PropertyType.getByName(split[0]);
                    Object value = type.parse(attr.getValue());
                    map.put(split[1], value);
                    continue;
                }
                throw new IllegalArgumentException("Invalid typed name: " + name);
            }
            return map;
        }
        catch (ParseException pe) {
            StreamException se = new StreamException(pe.getMessage());
            se.initCause(pe);
            throw se;
        }
    }

    public static Element processPropertiesMap(Document document, Map properties) {
        Element propertiesElement = document.createElement("properties");
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (typesMap.containsKey(value.getClass())) {
                key = (String)typesMap.get(value.getClass()) + ":" + key;
            }
            propertiesElement.setAttribute(key, value.toString());
        }
        return propertiesElement;
    }

    private static ReadableByteChannel getInflaterChannel(ReadableByteChannel channel) throws IOException {
        return new InflaterChannel(channel);
    }

    static {
        typesMap.put(Datum.class, "Datum");
        typesMap.put(Datum.Double.class, "Datum");
        typesMap.put(Integer.class, "int");
    }

    private static class ReadStreamStructure {
        private ReadableByteChannel stream;
        private ByteBuffer bigBuffer = ByteBuffer.allocate(4096);
        private byte[] four = new byte[4];
        private StreamHandler handler;
        private Map descriptors = new HashMap();
        private int byteOffset = 0;
        private int descriptorCount = 0;
        private int packetCount = 0;

        private ReadStreamStructure(ReadableByteChannel stream, StreamHandler handler) {
            this.stream = stream;
            this.handler = handler;
        }

        public String toString() {
            return "\ndescriptorCount=" + this.descriptorCount + "\npacketCount=" + this.packetCount + "\nbyteOffset=" + this.byteOffset + "\ncarotPos=" + (this.byteOffset - this.bigBuffer.limit() + this.bigBuffer.position()) + "\nbuffer=" + String.valueOf(this.bigBuffer);
        }
    }

    public static class DelimeterNotFoundException
    extends Exception {
    }
}

