/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;
import org.das2.util.monitor.ProgressMonitor;

public class DasProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private boolean started = false;
    private int bytesRead = 0;
    long birthTimeMilli;
    long deathTimeMilli;
    DecimalFormat transferRateFormat;
    boolean enableProgressPosition = true;
    private long streamLength = 1000000L;
    private long taskSize = this.streamLength / 1000L;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DasProgressMonitorInputStream(InputStream in, ProgressMonitor monitor) {
        super(in);
        this.monitor = monitor;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
    }

    private void reportTransmitSpeed() {
        if (this.transferRateFormat == null) {
            this.transferRateFormat = new DecimalFormat();
            this.transferRateFormat.setMaximumFractionDigits(2);
            this.transferRateFormat.setMinimumFractionDigits(2);
        }
        this.monitor.setProgressMessage("(" + this.transferRateFormat.format(this.calcTransmitSpeed() / 1024.0) + "kB/s)");
        if (this.enableProgressPosition) {
            this.monitor.setTaskProgress(this.bytesRead / 1000);
        }
    }

    private double calcTransmitSpeed() {
        long totalBytesRead = this.bytesRead;
        long timeElapsed = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (timeElapsed == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 1000L * totalBytesRead / timeElapsed;
    }

    public int read() throws IOException {
        this.checkCancelled();
        int result = super.read();
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                ++this.bytesRead;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        this.checkCancelled();
        int result = super.read(b);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        int result = super.read(b, off, len);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                this.monitor.finished();
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    private void checkCancelled() throws IOException {
        if (this.monitor != null && this.monitor.isCancelled()) {
            this.close();
            throw new InterruptedIOException("Operation cancelled");
        }
    }

    public void close() throws IOException {
        super.close();
        this.deathTimeMilli = System.currentTimeMillis();
        if (this.monitor != null) {
            this.monitor.finished();
            this.started = false;
        }
    }

    public void setEnableProgressPosition(boolean value) {
        this.enableProgressPosition = value;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public long getStreamLength() {
        return this.streamLength;
    }

    public void setStreamLength(long taskSize) {
        long oldTaskSize = this.streamLength;
        this.streamLength = taskSize;
        this.taskSize = taskSize == -1L ? taskSize : this.streamLength / 1000L;
        this.propertyChangeSupport.firePropertyChange("streamLength", new Long(oldTaskSize), new Long(taskSize));
    }
}

