/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.das2.DasProperties;

public class DasDie {
    public static int DEBUG = -20;
    public static int VERBOSE = -10;
    public static int INFORM = 0;
    public static int WARN = 10;
    public static int ALARM = 20;
    public static int CRITICAL = 30;
    public static int verbosity;

    private DasDie() {
    }

    public static void setDebugVerbosityLevel(String debugLevel) {
        verbosity = debugLevel.equals("endUser") ? WARN : (debugLevel.equals("dasDeveloper") ? DEBUG : INFORM);
    }

    private static final String calledBy() {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        String callStack = sw.toString();
        int atPos = callStack.indexOf("at");
        atPos = callStack.indexOf("at", atPos + 2);
        atPos = callStack.indexOf("at", atPos + 2);
        atPos = callStack.indexOf("at", atPos + 2);
        int nextAtPos = callStack.indexOf("at", atPos + 2);
        String calledBy = callStack.substring(atPos, nextAtPos - 2);
        return calledBy;
    }

    public static final void die(String message) {
        System.out.print(DasDie.calledBy() + ": ");
        DasDie.println(CRITICAL, message);
        System.exit(-1);
    }

    public static final void println(String message) {
        DasDie.println(DEBUG, message);
    }

    public static final void println(Object o) {
        DasDie.println(o.toString());
    }

    public static final void println(int verbosity, String message) {
        if (verbosity >= DasDie.verbosity) {
            System.err.println(message);
        }
    }

    public static final void print(String message) {
        DasDie.print(DEBUG, message);
    }

    public static final void print(Object o) {
        DasDie.print(o.toString());
    }

    public static final void print(int verbosity, String message) {
        if (verbosity >= DasDie.verbosity) {
            System.out.print(message);
        }
    }

    static {
        String debugLevel = DasProperties.getInstance().getProperty("debugLevel");
        DasDie.setDebugVerbosityLevel(debugLevel);
    }
}

