/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;

public class AxisAutoRangeController
implements DataSetUpdateListener,
PropertyChangeListener {
    DataSetDescriptor dsd;
    DasAxis xAxis;
    DasAxis yAxis;
    DasAxis zAxis;
    DasAxis myXAxis;
    DasAxis myYAxis;
    DasAxis myZAxis;
    Map xManualProps;
    Map yManualProps;
    Map zManualProps;
    boolean isAutomaticPropertyChange;

    public AxisAutoRangeController(DasAxis xAxis, DasAxis yAxis, DasAxis zAxis, DataSetDescriptor dsd) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        this.dsd = dsd;
        dsd.addDataSetUpdateListener(this);
        if (xAxis != null) {
            xAxis.addPropertyChangeListener(this);
        }
        if (yAxis != null) {
            yAxis.addPropertyChangeListener(this);
        }
        if (zAxis != null) {
            zAxis.addPropertyChangeListener(this);
        }
        this.xManualProps = new HashMap();
        this.yManualProps = new HashMap();
        this.zManualProps = new HashMap();
        this.isAutomaticPropertyChange = false;
    }

    public void dataSetUpdated(DataSetUpdateEvent e) {
        DasAxis newAxis;
        DataSet ds = e.getDataSet();
        if (ds == null) {
            return;
        }
        this.isAutomaticPropertyChange = true;
        if (this.xAxis != null) {
            newAxis = GraphUtil.guessXAxis(ds);
            if (!this.xManualProps.containsKey("dataMinimum")) {
                this.xAxis.setDatumRange(newAxis.getDatumRange());
            }
            if (!this.xManualProps.containsKey("log")) {
                this.xAxis.setLog(newAxis.isLog());
            }
            this.myXAxis = newAxis;
        }
        if (this.yAxis != null) {
            newAxis = GraphUtil.guessYAxis(ds);
            if (!this.yManualProps.containsKey("dataMinimum")) {
                this.yAxis.setDatumRange(newAxis.getDatumRange());
            }
            if (!this.yManualProps.containsKey("log")) {
                this.yAxis.setLog(newAxis.isLog());
            }
            if (!this.yManualProps.containsKey("label")) {
                this.yAxis.setLabel(newAxis.getLabel());
            }
            this.myYAxis = newAxis;
        }
        if (this.zAxis != null) {
            newAxis = GraphUtil.guessZAxis(ds);
            if (!this.zManualProps.containsKey("dataMinimum")) {
                this.zAxis.setDatumRange(newAxis.getDatumRange());
            }
            if (!this.zManualProps.containsKey("log")) {
                this.zAxis.setLog(newAxis.isLog());
            }
            if (!this.zManualProps.containsKey("label")) {
                this.zAxis.setLabel(newAxis.getLabel());
            }
            this.myZAxis = newAxis;
        }
        this.isAutomaticPropertyChange = false;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (!this.isAutomaticPropertyChange) {
            if (e.getSource() == this.xAxis) {
                this.xManualProps.put(e.getPropertyName(), e.getNewValue());
            } else if (e.getSource() == this.yAxis) {
                this.yManualProps.put(e.getPropertyName(), e.getNewValue());
            } else if (e.getSource() == this.zAxis) {
                this.zManualProps.put(e.getPropertyName(), e.getNewValue());
            }
        }
    }
}

