/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;

public final class RequestProcessor {
    private static final BlockingRequestQueue queue = new BlockingRequestQueue();
    private static final WeakHashMap runnableQueueMap = new WeakHashMap();
    private static final Runner runner = new Runner();
    private static int maxThreadCount = 4;
    private static int threadCount = 0;
    private static final Object THREAD_COUNT_LOCK = new Object();
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private static int threadOrdinal = 0;

    private RequestProcessor() {
    }

    private static void setJob(Runnable job) {
        RequestThread thread = (RequestThread)Thread.currentThread();
        thread.setJob(job);
    }

    private static void newThread() {
        String name = "RequestProcessor[" + threadOrdinal++ + "]";
        RequestThread t = new RequestThread(runner, name);
        t.setPriority(5);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run) {
        logger.fine("invokeLater " + run);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        queue.add(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run, Object lock) {
        logger.fine("invokeLater " + run + " " + lock);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                rq = new RunnableQueue();
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, false);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAfter(Runnable run, Object lock) {
        logger.fine("invokeAfter " + run + " " + lock);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                rq = new RunnableQueue();
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, true);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object lock) throws InterruptedException {
        WaitTask wt;
        WaitTask waitTask = wt = new WaitTask();
        synchronized (waitTask) {
            RequestProcessor.invokeLater(wt, lock);
            wt.wait();
            return;
        }
    }

    private static class BlockingRequestQueue {
        private LinkedList list = new LinkedList();

        BlockingRequestQueue() {
        }

        synchronized void add(Runnable r) {
            this.list.add(r);
            this.notify();
        }

        synchronized Runnable remove() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Runnable)this.list.removeFirst();
        }
    }

    private static class RequestEntry {
        Runnable run;
        boolean async;

        private RequestEntry() {
        }
    }

    private static class RunnableQueue
    implements Runnable {
        private LinkedList list = new LinkedList();
        private int readCount = 0;
        private Object writer;

        private RunnableQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunnableQueue runnableQueue;
            Runnable run = null;
            RequestEntry entry = null;
            Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
            while (run == null) {
                runnableQueue = this;
                synchronized (runnableQueue) {
                    entry = (RequestEntry)this.list.getFirst();
                    if (entry.async && this.readCount == 0 && this.writer == null) {
                        this.list.removeFirst();
                        this.writer = entry;
                        run = entry.run;
                    } else if (!entry.async && this.writer == null) {
                        this.list.removeFirst();
                        ++this.readCount;
                        run = entry.run;
                    }
                }
            }
            logger.fine("Starting :" + run);
            run.run();
            logger.fine("Finished :" + run);
            runnableQueue = this;
            synchronized (runnableQueue) {
                if (entry.async) {
                    this.writer = null;
                } else {
                    --this.readCount;
                }
                this.notifyAll();
            }
        }

        synchronized void add(Runnable run, boolean async) {
            RequestEntry entry = new RequestEntry();
            entry.run = run;
            entry.async = async;
            this.list.add(entry);
        }
    }

    private static class WaitTask
    implements Runnable {
        private WaitTask() {
        }

        public synchronized void run() {
            this.notifyAll();
        }
    }

    private static class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object = THREAD_COUNT_LOCK;
            synchronized (object) {
                threadCount++;
            }
            try {
                while (true) {
                    try {
                        while (true) {
                            Runnable run = queue.remove();
                            logger.fine("running " + run);
                            if (run != null) {
                                RequestProcessor.setJob(run);
                                run.run();
                                logger.fine("completed " + run);
                            }
                            Object object2 = THREAD_COUNT_LOCK;
                            synchronized (object2) {
                                if (threadCount > maxThreadCount) {
                                    return;
                                }
                            }
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        logger.fine("uncaught exception " + t);
                        DasExceptionHandler.handleUncaught(t);
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            finally {
                object = THREAD_COUNT_LOCK;
                synchronized (object) {
                    threadCount--;
                }
            }
        }
    }

    private static class RequestThread
    extends Thread {
        private WeakReference job;

        private RequestThread(Runnable run, String name) {
            super(run, name);
        }

        private void setJob(Runnable job) {
            this.job = new WeakReference<Runnable>(job);
        }

        private Runnable getJob() {
            return (Runnable)this.job.get();
        }
    }
}

