/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.das2.DasApplication;
import org.das2.system.LoggerId;

public class DasLogger {
    public static final LoggerId APPLICATION_LOG;
    public static final LoggerId SYSTEM_LOG;
    public static final LoggerId GUI_LOG;
    public static final LoggerId GRAPHICS_LOG;
    public static final LoggerId RENDERER_LOG;
    public static final LoggerId DATA_OPERATIONS_LOG;
    public static final LoggerId DATA_TRANSFER_LOG;
    public static final LoggerId FILESYSTEM_LOG;
    public static final LoggerId DASML_LOG;

    public static void reload() throws IOException {
        try {
            URL logConfigURL;
            File local;
            if (DasApplication.getProperty("user.name", "applet").equals("Web")) {
                local = new File("/tmp");
            } else {
                if (DasApplication.getProperty("user.name", "applet").equals("applet")) {
                    return;
                }
                local = new File(DasApplication.getProperty("user.home", "applet"));
            }
            File userDirectory = new File(local, ".das2");
            File localLogConfig = new File(userDirectory, "logging.properties");
            if (localLogConfig.exists()) {
                Logger.getLogger("").info("using " + localLogConfig);
                logConfigURL = localLogConfig.toURI().toURL();
            } else {
                logConfigURL = DasLogger.class.getResource("logging.properties");
            }
            if (logConfigURL == null) {
                System.err.println("unable to locate logging properties file logging.properties, using defaults");
            } else {
                InputStream in = logConfigURL.openStream();
                LogManager.getLogManager().readConfiguration(in);
                in.close();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void dumpUrl(URL url) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String s = reader.readLine();
        while (s != null) {
            System.out.println(s);
            s = reader.readLine();
        }
        reader.close();
    }

    public static void printStatus() {
        String[] loggers = new String[]{"", "das2.system", "das2.gui", "das2.graphics", "das2.dataOperations", "das2.dataTransfer"};
        for (int i = 0; i < loggers.length; ++i) {
            Logger logger = Logger.getLogger(loggers[i]);
            Level l = logger.getLevel();
            while (l == null) {
                logger = logger.getParent();
                l = logger.getLevel();
            }
            System.err.println(loggers[i] + " logging at " + l);
        }
    }

    public static Logger getLogger() {
        return APPLICATION_LOG.getLogger();
    }

    public static Logger getLogger(LoggerId loggerId) {
        return loggerId.getLogger();
    }

    public static Logger getLogger(LoggerId loggerId, String identifier) {
        String id = loggerId.toString() + "." + identifier;
        return Logger.getLogger(id);
    }

    public synchronized Logger getDebugLogger() {
        return Logger.getLogger("debug");
    }

    public static void addHandlerToAll(Handler h) {
        LoggerId[] loggers = new LoggerId[]{APPLICATION_LOG, SYSTEM_LOG, GUI_LOG, GRAPHICS_LOG, RENDERER_LOG, FILESYSTEM_LOG, DATA_TRANSFER_LOG, DATA_OPERATIONS_LOG, DASML_LOG};
        for (int i = 0; i < loggers.length; ++i) {
            Handler[] hh;
            Logger logger = loggers[i].getLogger();
            for (Handler h1 : hh = logger.getHandlers()) {
                if (!h.getClass().isInstance(h1)) continue;
                logger.removeHandler(h1);
            }
            logger.addHandler(h);
        }
    }

    static {
        try {
            DasLogger.reload();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        APPLICATION_LOG = new LoggerId("");
        SYSTEM_LOG = new LoggerId("das2.system");
        GUI_LOG = new LoggerId("das2.gui");
        GRAPHICS_LOG = new LoggerId("das2.graphics");
        RENDERER_LOG = new LoggerId("das2.graphics");
        DATA_OPERATIONS_LOG = new LoggerId("das2.dataOperations");
        DATA_TRANSFER_LOG = new LoggerId("das2.dataTransfer");
        FILESYSTEM_LOG = new LoggerId("das2.filesystem");
        DASML_LOG = new LoggerId("das2.dasml");
    }
}

