/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamYScanDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Units yUnits = Units.dimensionless;
    private Units zUnits = Units.dimensionless;
    private double[] yTags;
    private int nitems;
    private String name = "";
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    private double[] values;
    Map properties = new HashMap();

    public StreamYScanDescriptor(Element element) {
        if (element.getTagName().equals("yscan")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String name;
        String zUnitsString;
        String typeStr;
        DataTransferType type;
        this.nitems = Integer.parseInt(element.getAttribute("nitems"));
        String yTagsText = element.getAttribute("yTags");
        if (yTagsText != null) {
            this.yTags = new double[this.nitems];
            boolean parseInt = false;
            String[] tokens = yTagsText.split("\\s*,\\s*");
            for (int i = 0; i < this.nitems; ++i) {
                this.yTags[i] = Double.parseDouble(tokens[i]);
            }
        }
        if ((type = DataTransferType.getByName(typeStr = element.getAttribute("type"))) == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
        String yUnitsString = element.getAttribute("yUnits");
        if (yUnitsString != null) {
            this.yUnits = Units.getByName(yUnitsString);
        }
        if ((zUnitsString = element.getAttribute("zUnits")) != null) {
            this.zUnits = Units.getByName(zUnitsString);
        }
        if ((name = element.getAttribute("name")) != null) {
            this.name = name;
        }
    }

    private void processLegacyElement(Element element) {
        try {
            String typeStr;
            DataTransferType type;
            if (!element.getTagName().equals("YScan")) {
                throw new IllegalArgumentException("xml tree root node is not the right type. Node type is: " + element.getTagName());
            }
            this.nitems = Integer.parseInt(element.getAttribute("nitems"));
            if (element.getAttribute("yCoordinate") != null) {
                String yCoordinateString = element.getAttribute("yCoordinate");
                this.yTags = new double[this.nitems];
                int parseIdx = 0;
                for (int i = 0; i < this.nitems - 1; ++i) {
                    int toIdx = yCoordinateString.indexOf(",", parseIdx) - 1;
                    this.yTags[i] = Double.parseDouble(yCoordinateString.substring(parseIdx, toIdx));
                    parseIdx = toIdx + 2;
                }
                this.yTags[this.nitems - 1] = Double.parseDouble(yCoordinateString.substring(parseIdx));
            }
            if ((type = DataTransferType.getByName(typeStr = element.getAttribute("type"))) == null) {
                throw new RuntimeException("Illegal transfer type: " + typeStr);
            }
            this.transferType = type;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Error in das2stream at yCoordinate");
        }
        this.name = element.getAttribute("name") != null ? element.getAttribute("name") : "";
    }

    public StreamYScanDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[] getYTags() {
        return (double[])this.yTags.clone();
    }

    public void setYCoordinates(double[] yCoordinates) {
        this.yTags = (double[])yCoordinates.clone();
        this.nitems = yCoordinates.length;
    }

    public int getNItems() {
        return this.nitems;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void setZUnits(Units units) {
        this.zUnits = units;
    }

    public void setYCoordinates(DatumVector yCoords) {
        this.yUnits = yCoords.getUnits();
        this.yTags = yCoords.toDoubleArray(this.yUnits);
        this.nitems = this.yTags.length;
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public int getSizeBytes() {
        return this.nitems * this.transferType.getSizeBytes();
    }

    public DatumVector read(ByteBuffer input) {
        if (this.values == null) {
            this.values = new double[this.nitems];
        }
        for (int i = 0; i < this.nitems; ++i) {
            this.values[i] = this.transferType.read(input);
        }
        return DatumVector.newDatumVector(this.values, this.zUnits);
    }

    public void write(DatumVector input, ByteBuffer output) {
        this.values = input.toDoubleArray(this.values, this.zUnits);
        for (int i = 0; i < this.nitems; ++i) {
            this.transferType.write(this.values[i], output);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("yscan");
        element.setAttribute("nitems", String.valueOf(this.nitems));
        element.setAttribute("yTags", StreamYScanDescriptor.toString(this.yTags));
        element.setAttribute("yUnits", this.yUnits.toString());
        element.setAttribute("zUnits", this.zUnits.toString());
        element.setAttribute("type", this.transferType.toString());
        if (this.name != null && !this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    private static String toString(double[] d) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buffer.append(", ").append(d[i]);
        }
        return buffer.toString();
    }

    public Object clone() {
        try {
            StreamYScanDescriptor clone = (StreamYScanDescriptor)super.clone();
            clone.yTags = (double[])this.yTags.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public String toString() {
        return "<yScan nitems=" + this.nitems + ">";
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

