/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StreamMultiYDescriptor
implements SkeletonDescriptor,
Cloneable {
    private String name = "";
    private Units units = Units.dimensionless;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    Map properties = new HashMap();

    public StreamMultiYDescriptor(Element element) {
        if (element.getTagName().equals("y")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String name = element.getAttribute("name");
        if (name != null) {
            this.name = name;
        }
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        String unitsString = element.getAttribute("units");
        if (unitsString != null) {
            this.units = Units.getByName(unitsString);
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node n = attrs.item(i);
            this.properties.put(n.getNodeName(), n.getNodeValue());
        }
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
    }

    private void processLegacyElement(Element element) {
        this.name = element.getAttribute("name") != null ? element.getAttribute("name") : "";
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
    }

    public StreamMultiYDescriptor() {
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public DatumVector read(ByteBuffer input) {
        return DatumVector.newDatumVector(new double[]{this.transferType.read(input)}, this.units);
    }

    public void write(DatumVector input, ByteBuffer output) {
        this.transferType.write(input.doubleValue(0, this.units), output);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("y");
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        if (!this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

