/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.util.StreamTool;

public class Sonifier
implements StreamHandler {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    byte[] buffer;
    SourceDataLine line = null;
    int bufferInputIndex;

    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        double max = 1.0;
        this.buffer[this.bufferInputIndex++] = (byte)(256.0 * vectors[0].doubleValue(0, vectors[0].getUnits()));
        if (this.bufferInputIndex == 100) {
            this.line.write(this.buffer, 0, this.bufferInputIndex);
            this.bufferInputIndex = 0;
        }
    }

    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
    }

    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.line.drain();
        this.line.close();
    }

    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        AudioFormat audioFormat = new AudioFormat(8000.0f, 8, 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.buffer = new byte[128000];
        this.bufferInputIndex = 0;
        this.line.start();
    }

    public void streamException(StreamException se) throws StreamException {
        se.printStackTrace();
        System.exit(0);
    }

    public void streamComment(StreamComment sc) throws StreamException {
    }

    public static void main(String[] args) throws Exception {
        InputStream in = args.length == 0 ? System.in : new FileInputStream(args[0]);
        ReadableByteChannel channel = Channels.newChannel(in);
        StreamTool.readStream(channel, new Sonifier());
    }
}

