/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamMultiYDescriptor;
import org.das2.stream.StreamXDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.util.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PacketDescriptor
implements Cloneable {
    private StreamXDescriptor xDescriptor;
    private SkeletonDescriptor[] yDescriptors = new SkeletonDescriptor[6];
    private int yCount = 0;
    private Map properties;
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");

    public PacketDescriptor(Element element) {
        this.properties = new HashMap();
        if (element.getTagName().equals("packet")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Cloneable d;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if (name.equals("x")) {
                this.xDescriptor = new StreamXDescriptor(child);
                continue;
            }
            if (name.equals("y")) {
                d = new StreamMultiYDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (name.equals("yscan")) {
                d = new StreamYScanDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (!name.equals("properties")) continue;
            try {
                NodeList list = element.getElementsByTagName("properties");
                if (list.getLength() == 0) continue;
                Element propertiesElement = (Element)list.item(0);
                Map m = StreamTool.processPropertiesElement(propertiesElement);
                this.properties.putAll(m);
                continue;
            }
            catch (StreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processLegacyElement(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Cloneable d;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if (name.equals("X")) {
                this.xDescriptor = new StreamXDescriptor(child);
                continue;
            }
            if (name.equals("YScan")) {
                d = new StreamYScanDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (!name.equals("MultiY")) continue;
            d = new StreamMultiYDescriptor(child);
            this.addYDescriptor((SkeletonDescriptor)((Object)d));
        }
    }

    public PacketDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor x) {
        this.xDescriptor = x;
    }

    public void addYDescriptor(SkeletonDescriptor y) {
        if (this.yCount == this.yDescriptors.length) {
            SkeletonDescriptor[] temp = new SkeletonDescriptor[this.yCount * 2];
            System.arraycopy(this.yDescriptors, 0, temp, 0, this.yCount);
            this.yDescriptors = temp;
        }
        this.yDescriptors[this.yCount] = y;
        ++this.yCount;
    }

    public int getYCount() {
        return this.yCount;
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.yDescriptors).subList(0, this.yCount));
    }

    public SkeletonDescriptor getYDescriptor(int index) {
        if (index < 0 || index >= this.yCount) {
            throw new IndexOutOfBoundsException("index = " + index + ", yCount = " + this.yCount);
        }
        return this.yDescriptors[index];
    }

    public int getSizeBytes() {
        int sizeBytes = this.xDescriptor.getSizeBytes();
        for (int i = 0; i < this.yCount; ++i) {
            sizeBytes += this.yDescriptors[i].getSizeBytes();
        }
        return sizeBytes;
    }

    public DatumVector[] read(ByteBuffer input) {
        DatumVector[] vectors = new DatumVector[this.yCount + 1];
        vectors[0] = this.xDescriptor.read(input);
        for (int i = 0; i < this.yCount; ++i) {
            vectors[i + 1] = this.yDescriptors[i].read(input);
        }
        return vectors;
    }

    public void write(Datum xTag, DatumVector[] vectors, ByteBuffer output) {
        this.xDescriptor.writeDatum(xTag, output);
        for (int i = 0; i < this.yCount; ++i) {
            this.yDescriptors[i].write(vectors[i], output);
        }
        if (this.yDescriptors[this.yCount - 1] instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)output.get(output.position() - 1))) {
            output.put(output.position() - 1, (byte)10);
        } else if (this.yDescriptors[this.yCount - 1] instanceof StreamMultiYDescriptor && ((StreamMultiYDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)output.get(output.position() - 1))) {
            output.put(output.position() - 1, (byte)10);
        }
    }

    private static String trimComment(String line) {
        int index = line.indexOf(59);
        if (index == 0) {
            return "";
        }
        if (index != -1) {
            return line.substring(0, index);
        }
        return line;
    }

    public static PacketDescriptor createLegacyPacketDescriptor(Map dsdf) {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setXDescriptor(new StreamXDescriptor());
        if (dsdf.get("form").equals("x_tagged_y_scan")) {
            StreamYScanDescriptor yscan = new StreamYScanDescriptor();
            yscan.setYCoordinates((double[])dsdf.get("y_coordinate"));
            packetDescriptor.addYDescriptor(yscan);
        } else if (dsdf.get("form").equals("x_multi_y") && dsdf.get("ny") != null) {
            StreamMultiYDescriptor y = new StreamMultiYDescriptor();
            packetDescriptor.addYDescriptor(y);
        } else if (dsdf.get("form").equals("x_multi_y") && dsdf.get("items") != null) {
            List planeList = (List)dsdf.get("plane-list");
            packetDescriptor.addYDescriptor(new StreamMultiYDescriptor());
            for (int index = 0; index < planeList.size(); ++index) {
                StreamMultiYDescriptor y = new StreamMultiYDescriptor();
                y.setName((String)planeList.get(index));
                packetDescriptor.addYDescriptor(y);
            }
        }
        return packetDescriptor;
    }

    private static String[] ensureCapacity(String[] array, int capacity) {
        if (array == null) {
            return new String[capacity];
        }
        if (array.length >= capacity) {
            return array;
        }
        String[] temp = new String[capacity];
        System.arraycopy(array, 0, temp, 0, array.length);
        return temp;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("packet");
        element.appendChild(this.xDescriptor.getDOMElement(document));
        for (int i = 0; i < this.yCount; ++i) {
            element.appendChild(this.yDescriptors[i].getDOMElement(document));
        }
        return element;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object clone() {
        try {
            PacketDescriptor clone = (PacketDescriptor)super.clone();
            clone.xDescriptor = (StreamXDescriptor)this.xDescriptor.clone();
            clone.yDescriptors = new SkeletonDescriptor[this.yCount];
            for (int i = 0; i < this.yCount; ++i) {
                clone.yDescriptors[i] = (SkeletonDescriptor)this.yDescriptors[i].clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public String toString() {
        String result = "<packet>\n";
        for (int iplane = 0; iplane < this.yCount; ++iplane) {
            result = result + this.yDescriptors[iplane].toString() + "\n";
        }
        result = result + "</packet>\n";
        return result;
    }
}

