/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft.jnt;

import org.das2.math.fft.ComplexArray;
import org.das2.math.fft.jnt.ComplexDoubleFFT;
import org.das2.math.fft.jnt.RealDoubleFFT;

public class RealDoubleFFT_Even
extends RealDoubleFFT {
    ComplexDoubleFFT fft;

    public RealDoubleFFT_Even(int n) {
        super(n);
        throw new RuntimeException("Not verified--and it looks bad!");
    }

    public void transform(ComplexArray.Double data) {
        this.fft.transform(data);
        this.shuffle(data, 1);
    }

    public ComplexArray.Double toWraparoundOrder(ComplexArray.Double data) {
        ComplexArray.Double newdata = ComplexArray.newArray(new double[this.n], new double[this.n]);
        int nh = this.n / 2;
        newdata.setReal(0, data.getReal(0));
        newdata.setReal(1, 0.0);
        newdata.setReal(this.n, data.getReal(1));
        newdata.setImag(this.n, 0.0);
        for (int i = 1; i < nh; ++i) {
            newdata.setReal(2 * i, data.getReal(2 * i));
            newdata.setImag(2 * i, data.getImag(2 * i));
            newdata.setReal(2 * (this.n - i), data.getReal(2 * i));
            newdata.setImag(2 * (this.n - i), -data.getImag(2 * i));
        }
        return newdata;
    }

    public double[] toWraparoundOrder(ComplexArray.Double data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void backtransform(ComplexArray.Double data) {
        this.shuffle(data, -1);
        this.fft.backtransform(data);
    }

    private void shuffle(ComplexArray.Double data, int sign) {
        int nh = this.n / 2;
        int nq = this.n / 4;
        double c1 = 0.5;
        double c2 = -0.5 * (double)sign;
        double theta = (double)sign * Math.PI / (double)nh;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = -Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        for (int i = 1; i < nq; ++i) {
            int i1 = 2 * i;
            int i3 = this.n - i1;
            double h1r = c1 * (data.getReal(i1) + data.getReal(i3));
            double h1i = c1 * (data.getReal(i1 + 1) - data.getImag(i3));
            double h2r = -c2 * (data.getReal(i1 + 1) + data.getImag(i3));
            double h2i = c2 * (data.getReal(i1) - data.getReal(i3));
            data.setReal(i1, h1r + wr * h2r - wi * h2i);
            data.setImag(i1, h1i + wr * h2i + wi * h2r);
            data.setReal(i3, h1r - wr * h2r + wi * h2i);
            data.setImag(i3, -h1i + wr * h2i + wi * h2r);
            wtemp = wr;
            wr += wtemp * wpr - wi * wpi;
            wi += wtemp * wpi + wi * wpr;
        }
        double d0 = data.getReal(0);
        if (sign == 1) {
            data.setReal(0, d0 + data.getReal(1));
            data.setReal(1, d0 - data.getReal(1));
        } else {
            data.setReal(0, c1 * (d0 + data.getReal(1)));
            data.setReal(1, c1 * (d0 - data.getReal(1)));
        }
        if (this.n % 4 == 0) {
            data.setImag(nh, data.getImag(nh) * -1.0);
        }
    }

    public void transform(ComplexArray.Double data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void backtransform(ComplexArray.Double data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void inverse(ComplexArray.Double data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public double normalization() {
        return 2.0 / (double)this.n;
    }

    public void inverse(ComplexArray.Double data) {
        this.backtransform(data);
        double norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
        }
    }
}

