/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft;

import org.das2.math.fft.ComplexArray;
import org.das2.math.fft.jnt.ComplexDoubleFFT;
import org.das2.math.fft.jnt.ComplexDoubleFFT_Mixed;
import org.das2.math.fft.jnt.ComplexFloatFFT;
import org.das2.math.fft.jnt.ComplexFloatFFT_Mixed;
import org.das2.math.fft.jnt.RealDoubleFFT;
import org.das2.math.fft.jnt.RealDoubleFFT_Even;

public class GeneralFFT {
    boolean doublePrecision;
    int n;
    ComplexDoubleFFT complexDoubleFFT;
    ComplexFloatFFT complexFloatFFT;
    RealDoubleFFT realDoubleFFT;
    boolean real;
    private static final double LOG_2 = Math.log(2.0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralFFT(int n, boolean doublePrecision, boolean real) {
        this.n = n;
        this.doublePrecision = doublePrecision;
        if (n < 2 || (double)n > Math.pow(2.0, 100.0)) {
            throw new IllegalArgumentException("n too big or too small, n=" + n);
        }
        this.real = false;
        if (doublePrecision) {
            this.complexDoubleFFT = new ComplexDoubleFFT_Mixed(n);
        } else {
            this.complexFloatFFT = new ComplexFloatFFT_Mixed(n);
        }
        if (this.real) {
            if (n % 2 != 0) {
                throw new IllegalArgumentException("n must be even");
            }
            if (!doublePrecision) throw new UnsupportedOperationException("not implemented");
            this.realDoubleFFT = new RealDoubleFFT_Even(n);
            return;
        } else if (doublePrecision) {
            this.complexDoubleFFT = new ComplexDoubleFFT_Mixed(n);
            return;
        } else {
            this.complexFloatFFT = new ComplexFloatFFT_Mixed(n);
        }
    }

    public static GeneralFFT newFloatFFT(int n) {
        return new GeneralFFT(n, false, false);
    }

    public static GeneralFFT newDoubleFFT(int n) {
        return new GeneralFFT(n, true, false);
    }

    public void transform(ComplexArray.Double data) {
        double norm;
        if (!this.doublePrecision) {
            throw new IllegalArgumentException("expected float arrays, got doubles");
        }
        if (this.real) {
            this.realDoubleFFT.transform(data);
            norm = this.realDoubleFFT.normalization();
        } else {
            this.complexDoubleFFT.transform(data);
            norm = this.complexDoubleFFT.normalization();
        }
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }

    public void transform(ComplexArray.Float data) {
        if (this.doublePrecision) {
            throw new IllegalArgumentException("expected double arrays, got floats");
        }
        this.complexFloatFFT.transform(data);
        float norm = this.complexFloatFFT.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }

    public void invTransform(ComplexArray.Double data) {
        if (!this.doublePrecision) {
            throw new IllegalArgumentException("expected float arrays, got doubles");
        }
        this.complexDoubleFFT.inverse(data);
    }

    public void invTransform(ComplexArray.Float data) {
        if (this.doublePrecision) {
            throw new IllegalArgumentException("expected double arrays, got floats");
        }
        this.complexFloatFFT.inverse(data);
    }
}

