/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import org.das2.math.RealPoint;

class Vector {
    float u;
    float v;

    Vector() {
        this.v = 0.0f;
        this.u = 0.0f;
    }

    Vector(RealPoint p1, RealPoint p2) {
        this.u = p2.x() - p1.x();
        this.v = p2.y() - p1.y();
    }

    Vector(float u, float v) {
        this.u = u;
        this.v = v;
    }

    float dotProduct(Vector v) {
        return this.u * v.u + this.v * v.v;
    }

    static float dotProduct(RealPoint p1, RealPoint p2, RealPoint p3) {
        float u1 = p2.x() - p1.x();
        float v1 = p2.y() - p1.y();
        float u2 = p3.x() - p1.x();
        float v2 = p3.y() - p1.y();
        return u1 * u2 + v1 * v2;
    }

    float crossProduct(Vector v) {
        return this.u * v.v - this.v * v.u;
    }

    static float crossProduct(RealPoint p1, RealPoint p2, RealPoint p3) {
        float u1 = p2.x() - p1.x();
        float v1 = p2.y() - p1.y();
        float u2 = p3.x() - p1.x();
        float v2 = p3.y() - p1.y();
        return u1 * v2 - v1 * u2;
    }

    void setRealPoints(RealPoint p1, RealPoint p2) {
        this.u = p2.x() - p1.x();
        this.v = p2.y() - p1.y();
    }
}

